// Copyright (C) 2011 Kornel Kisielewicz
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/gl/image.hh"

#include <cstring>

using namespace nv;

image::image( glm::ivec2 size, size_t depth )
	: m_size( size ), m_depth( depth ), m_data( nullptr )
{
	m_data = new uint8[ m_size.x * m_size.y * m_depth ];
}

void image::fill( uint8 value )
{
	memset( m_data, value, m_size.x * m_size.y * m_depth );
}

void image::set_region( region r, const uint8 * data, size_t stride )
{
	if ( stride == 0 ) stride = r.size.x;

    for( size_t i = 0; i < r.size.y; ++i )
    {
        memcpy( m_data+((r.pos.y+i)*m_size.x + r.pos.x ) * m_depth, 
                data + (i*stride), r.size.x * m_depth );
    }
}

image::~image()
{
	delete[] m_data;
}

