// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
 * @file gui_environment.hh
 * @author Kornel Kisielewicz
 * @brief GUI Environment (root)
 */

#ifndef NV_GUI_ENVIRONMENT_HH
#define NV_GUI_ENVIRONMENT_HH

#include <nv/gui/gui_element.hh>
#include <nv/gui/gui_style.hh>
#include <nv/lua/lua_state.hh>
#include <nv/interface/window.hh>
#include <nv/root.hh>

namespace nv
{

	namespace gui
	{
		class screen : public element
		{
		public:
			screen( root* aroot, const rectangle& r ) : element( aroot, r ) {}
			virtual bool on_event( const io_event& ) { return false; }
			virtual void recalculate_absolute() { recalculate_absolute_children(); }
		};

		class environment : public root
		{
		public:
			environment( window* w );
			// temporary
			void load_style( const std::string& filename );
			void update( element* e, uint32 elapsed );
			void draw( element* e );
			void update();
			void draw();
			virtual void add_child( object* child );
			virtual ~environment();
		protected:
			renderer*    m_renderer;
			window*      m_window;
			screen*      m_screen;
			rectangle    m_area;
		};

	} // namespace gui

} // namespace nv

#endif // NV_GUI_ENVIRONMENT_HH
