// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
/**
 * @file stream.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief stream interface
 */

#ifndef NV_C_FILE_SYSTEM_HH
#define NV_C_FILE_SYSTEM_HH

#include <nv/common.hh>
#include <nv/interface/file_system.hh>

namespace nv
{

	class c_file_system : public file_system
	{
	public:
		c_file_system();
		virtual ~c_file_system();
		virtual bool exists( const char* fpath );
		virtual stream* open( const char* fpath, const char* fmode = "rb" );
	};

} // namespace nv

#endif // NV_C_FILE_SYSTEM_HH
