// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
/**
 * @file gl_vertex_buffer.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief Vertex buffer implementation
 */

#ifndef NV_GL_VERTEX_BUFFER_HH
#define NV_GL_VERTEX_BUFFER_HH

#include <nv/interface/vertex_buffer.hh>
#include <nv/gl/gl_names.hh>

namespace nv
{

	class gl_vertex_buffer : public vertex_buffer
	{
	public:
		gl_vertex_buffer( buffer_hint hint, size_t size, void* data = nullptr );
		virtual void update( void* data, size_t offset, size_t size );
		virtual void bind();
		virtual void unbind();
		virtual bool is_valid() const;
	private:
		gl_buffer_name m_name;
	};

	class gl_index_buffer : public index_buffer
	{
	public:
		gl_index_buffer( buffer_hint hint, size_t size, void* data = nullptr );
		virtual void update( void* data, size_t offset, size_t size );
		virtual void bind();
		virtual void unbind();
		virtual bool is_valid() const;
	private:
		gl_buffer_name m_name;
	};

	class gl_vertex_array : public vertex_array
	{
	public:
		gl_vertex_array();
		virtual void bind();
		virtual void unbind();
	};

} // namespace nv

#endif // NV_GL_VERTEX_BUFFER_HH
