// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/gui/gui_element.hh"

#include "nv/gui/gui_environment.hh"

using namespace nv;
using namespace nv::gui;

element::element( root* aroot, const rectangle& r ) 
	: object( aroot, "" ), m_class(""), m_relative( r ), m_absolute( r ), m_enabled( true ), m_visible( true ), m_dirty( true ), m_render_data( nullptr )
{

}

void element::on_update( uint32 elapsed )
{
	if ( is_visible() )
	{
		for ( object* i : *this )
		{
			((element*)i)->on_update( elapsed );
		}
	}
	//((environment*)m_root)->update( this, elapsed );
}

void element::on_draw()
{
	if ( is_visible() )
	{
		((environment*)m_root)->draw( this );
		for ( object* i : *this )
		{
			((element*)i)->on_draw();
		}
	}
}

bool element::on_event( const io_event& event )
{
	return m_parent ? ((element*)m_parent)->on_event( event ) : false;
}

element* element::get_element( const position& p )
{
	if ( !is_visible() ) return nullptr;

	element* result = nullptr;
	list::reverse_iterator it = m_children.rbegin();

	while ( it != m_children.rend() )
	{
		result = ((element*)(*it))->get_element( p );
		if ( result ) return result;
		++it;
	}

	if ( contains( p ) ) return this;
	return nullptr;
}

bool element::contains( const position& p ) const
{
	return m_absolute.contains( p );
}

void element::set_relative( const rectangle& r )
{
	m_dirty    = true;
	m_relative = r;
	recalculate_absolute();
}

void element::set_relative( const position& p )
{
	set_relative( rectangle( p, p + m_relative.get_size() ) );
}

void element::recalculate_absolute()
{
	rectangle pabsolute;

	if ( m_parent )
	{
		pabsolute = ((element*)(m_parent))->m_absolute;
	}

	m_absolute = m_relative + pabsolute.ul;

	for ( object* o : *this )
	{
		((element*)o)->recalculate_absolute();
	}
}

void element::recalculate_absolute_children()
{
	for ( object* o : *this )
	{
		((element*)o)->recalculate_absolute();
	}
}

element::~element()
{
	delete m_render_data;
}
