project "nv"
	location (_ACTION)
	language "C++"
	kind "StaticLib"
	includedirs { "." }
	files { "nv/**.hh", "nv/**.inl", "src/**.cc" }
	targetname "nv"

-- injection!
solution( solution().name )
	configuration "*"
		includedirs { os.getenv("GLM_PATH") }
	configuration "gmake"
		buildoptions "-std=c++0x"
	configuration "vs*"
		defines { "_SECURE_SCL=0", "_CRT_SECURE_NO_WARNINGS=1" }

if _ACTION == "gmake-clang" then
	premake.gcc.cc  = "clang"
	premake.gcc.cxx = "clang++"
	_ACTION = "gmake"
end

premake.action.add { 
	trigger = "gmake-clang", 
	description = "gmake file with clang overrides, needs 'make -R' to work",
}

if _ACTION == "clean" then
	for action in premake.action.each() do
		os.rmdir(action.trigger)
	end
end