// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#ifndef NV_GL_TEXTURE_ATLAS_HH
#define NV_GL_TEXTURE_ATLAS_HH

#include <nv/common.hh>
#include <glm/glm.hpp>
#include <vector>

namespace nv
{

	class texture_atlas
	{
	public:
		texture_atlas( glm::ivec2 size, size_t depth );
		glm::ivec4 get_region( glm::ivec2 size );
		void set_region( glm::ivec4 region, const uint8 * data, size_t stride );
		void clear();
		void fill( uint8 value );
		~texture_atlas();
		const uint8 * get_data() const { return m_data; }
		const glm::ivec2 get_size() const { return m_size; }
		const size_t get_depth() const { return m_depth; }
		const size_t get_used() const { return m_used; }
	protected:
		int fit( size_t index, glm::ivec2 size );
		void merge();
	private:
	    glm::ivec2 m_size;
	    size_t  m_depth;
	    size_t  m_used;

	    uint8 * m_data;
		std::vector<glm::ivec3> m_nodes;
	};

}

#endif // NV_GL_TEXTURE_ATLAS_HH