#include <nv/lib/lua.hh>
#include <nv/lua/lua_state.hh>
#include <nv/lua/lua_raw.hh>
#include <nv/lua/lua_glm.hh>
#include <nv/logger.hh>
#include <nv/types.hh>
#include <nv/object.hh>
#include <string>
#include <iostream>
#include <functional>
#include <nv/gui/gui_element.hh>

struct test_struct
{
	std::string f;
	int i;
};

int main(int, char* [])
{
	nv::logger log(nv::LOG_TRACE);
	log.add_sink( new nv::log_file_sink("log.txt"), nv::LOG_TRACE );
	log.add_sink( new nv::log_console_sink(), nv::LOG_TRACE );
	
	NV_LOG( nv::LOG_NOTICE, "Logging started" );

	// create new Lua state
	{
		nv::lua::state state( true );
		nlua_register_glm( state );
		// run the Lua script
		state.do_file( "init.lua" );

		for (;;)
		{
			nv::lua::stack_guard guard( state );
			int stack = guard.get_level();
			std::string input;
			std::cout << "LUA (" << stack << ") > ";
			std::getline( std::cin, input );
			if (input == "quit")
			{
				break;
			}

			if (input.find("=", 0) == std::string::npos && 
				input.find("if", 0) == std::string::npos && 
				input.find("return", 0) == std::string::npos)
			{
				input = "return " + input;
			}

			std::cout << "> " << input << std::endl;

			bool result = state.do_string( input, "", nv::lua::ret_multi );
			if ( !result )
			{
				std::string error = lua_tostring( state, -1 );
				std::cout << "ERROR : " << error << std::endl;
				continue;
			}

			if (lua_gettop( state ) > stack)
			{
				for ( int i = stack+1; i <= lua_gettop( state ); ++i )
				{
					std::cout << nlua_typecontent( state, i ) << std::endl;
				}
			}
		}
	}
	NV_LOG( nv::LOG_NOTICE, "Logging stopped" );

	return 0;
}

