// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
 * @file gui_element.hh
 * @author Kornel Kisielewicz
 * @brief GUI Element
 */

#ifndef NV_GUI_ELEMENT_HH
#define NV_GUI_ELEMENT_HH

#include <nv/object.hh>
#include <nv/position.hh>
#include <nv/io_event.hh>
#include <nv/gui/gui_common.hh>

namespace nv
{
	namespace gui
	{
		class element : public object
		{
		public:
			element() : object() {}
			element( root* aroot, const rectangle r );
			element* get_element( const position& p );
			virtual void on_update( uint32 elapsed );
			virtual void on_draw();
			virtual bool on_event( const io_event& event );
			virtual bool contains( const position& p ) const;
			virtual void set_relative( const rectangle& r );
			virtual void set_relative( const position& p );
			virtual const rectangle& get_relative() const { return m_relative; }
			virtual const rectangle& get_absolute() const { return m_absolute; }
			virtual element* get_parent() const { return (element*)m_parent; }
			virtual bool is_enabled() const { return m_enabled; }
			virtual bool is_visible() const { return m_visible; }
			virtual bool is_dirty()   const { return m_dirty; }
			virtual void set_enabled( bool value ) { m_enabled = value; }
			virtual void set_visible( bool value ) { m_visible = value; }
			virtual void set_dirty( bool value )   { m_dirty   = value; }
			virtual const string& get_text() const { return m_text; }
			virtual void set_text( const string& text ) { m_text = text; m_dirty = true; }
			virtual const string& get_class() const { return m_class; }
			virtual void set_class( const string& class_ ) { m_class = class_; m_dirty = true; }
			virtual void recalculate_absolute();
		protected:
			string    m_class;
			string    m_text;
			rectangle m_relative;
			rectangle m_absolute;
			bool m_enabled;
			bool m_visible;
			bool m_dirty;
			render_data* m_render_data;
		};

	} // namespace gui

} // namespace nv

#endif // NV_GUI_ELEMENT_HH
