// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
/**
 * @file gl_window.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief Window interface
 */

#ifndef NV_GL_WINDOW_HH
#define NV_GL_WINDOW_HH

#include <nv/interface/window.hh>
#include <nv/gl/gl_context.hh>

namespace nv
{

	class gl_window : public window
	{
	public:
		gl_window( uint16 width, uint16 height );
		uint16 get_width() const;
		uint16 get_height() const;
		string get_title() const;
		void set_title( const string& title );
		virtual context* get_context() { return m_context; }
		~gl_window();
	private:
		uint16      m_width;
		uint16      m_height;
		string      m_title;
		void*       m_screen;
		gl_context* m_context;
	};

} // namespace nv

#endif // NV_GL_WINDOW_HH
