// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
/**
 * @file gl_program.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief Program class
 */

#ifndef NV_GL_PROGRAM_HH
#define NV_GL_PROGRAM_HH

#include <nv/common.hh>
#include <nv/interface/program.hh>
#include <nv/string.hh>
#include <nv/gl/gl_names.hh>

namespace nv
{

	class gl_shader
	{
	public:
		explicit gl_shader( uint32 shader_type );
		gl_shader( uint32 shader_type, const string& shader_code );
		~gl_shader();

		bool compile( const std::string& shader_code );

		void generate();
		void free();
		bool validate();

		bool is_valid() const { return object_id != 0; }
		unsigned int get_id() const	{ return object_id;	}
	private:
		uint32 shader_type;
		uint32 object_id;
	};

	class gl_program : public program
	{
	public:
		gl_program( const string& vertex_program, const string& fragment_program );
		bool compile( const string& vertex_program, const string& fragment_program );

		virtual void bind();
		virtual void unbind();
		virtual bool is_valid() const;

		~gl_program();
	protected:
		bool validate();
		void update_uniforms();
		void load_attributes();
		void load_uniforms();

		gl_shader_name m_name;
		gl_shader vertex_shader;
		gl_shader fragment_shader;
	};

} // namespace nv

#endif // NV_GL_PROGRAM_HH
