// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
 * @file resource.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief resource implementation
 */

#ifndef NV_RESOURCE_HH
#define NV_RESOURCE_HH

#include <nv/common.hh>
#include <memory>

namespace nv
{

	class resource
	{
	public:
		typedef std::shared_ptr< resource > ptr;
	public:
		virtual bool load() = 0;
		virtual bool unload() = 0;
		bool is_loaded() const { return m_loaded; }
		uid get_rid() const { return m_rid; }
		uid get_size() const { return m_size; }
	private:
		uint32 m_size;
		uint32 m_rid;
		bool   m_loaded;
	};

}

#endif // NV_RESOURCE_HH
