// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
 * @file uid.hh
 * @author Kornel Kisielewicz
 * @brief Implements a unique identifier class manager
 */

#ifndef NV_UID_HH
#define NV_UID_HH

#include <nv/common.hh>
#include <unordered_map>

namespace nv
{
	class uid_store
	{
	public:
		uid_store();
		object* get( uid auid ) const;
		bool remove( uid auid );
		void insert( object* o, uid auid );
		uid insert( object* o );
		uid request_uid();
		~uid_store();
		template< typename T >
		T* get_as( uid auid ) const 
		{
			return dynamic_cast< T* >( get(auid) );
		}
	private:
		typedef std::unordered_map< uid, object* > map;
		map m_map;
		uid m_current;
	};
}

#endif // NV_UID_HH
