// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
 * @file logging.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief logging interfaces
 */

#ifndef NV_LOGGING_HH
#define NV_LOGGING_HH

#include <nv/singleton.hh>
#include <sstream>
#include <string>

namespace nv
{

    enum log_level
    {
		LOG_NONE     = 0,
        LOG_FATAL    = 10,
        LOG_CRITICAL = 20,
        LOG_ERROR    = 30,
        LOG_WARNING  = 40,
        LOG_NOTICE   = 50,
        LOG_INFO     = 60,
        LOG_DEBUG    = 80,
        LOG_TRACE    = 100
    };

	class logger_base : public singleton< logger_base >
	{
	public:
		unsigned int get_level()
		{
			return level;
		};
		void set_level( unsigned int level )
		{
			level = level;
		};
		virtual void log( log_level level, const std::string& message ) = 0;
	protected:
		unsigned int level;
	};

} // namespace nv

#define NV_LOG(level, message_stream) \
    if ( nv::logger_base::is_valid() && \
		(unsigned int)nv::logger_base::reference().get_level() >= level ) \
    {       \
        std::stringstream ss; \
        ss << message_stream; \
        nv::logger_base::reference().log( level, ss.str() ); \
    }

#if NV_DEBUG == 1
#define NV_DEBUG_LOG(level, message_stream) \
	if ( nv::logger_base::is_valid() && \
		(unsigned int)nv::logger_base::reference().get_level() >= level ) \
	{       \
		std::stringstream ss; \
		ss << message_stream; \
		nv::logger_base::reference().log( level, ss.str() ); \
	}
#else
#define NV_DEBUG_LOG(level, message_stream)
#endif

#endif // NV_LOGGING_HH
