#version 120
varying vec3 f_coord;
varying vec3 f_normal;
varying vec3 f_material;
varying float f_diffuse_value;
uniform sampler2D tex;
uniform vec3 light;
 
void main(void) {
	float w = f_material.x;
	bool secondary = f_normal.y < 0.1;
	float remmod  = floor( w / 16 + 0.5 );
	float modulus = w - remmod * 16;
	float dist = distance( light, f_coord );
	float dmod = clamp(5.0 - dist, 0.0, 1.0) * f_diffuse_value;

	if (secondary)
		gl_FragColor = texture2D(tex, vec2((fract(f_coord.z - f_coord.x) + modulus ), ( fract(-f_coord.y) + remmod) )  / 16.0);
	else
		gl_FragColor = texture2D(tex, vec2((fract(f_coord.z) + modulus ), ( fract(f_coord.x) + remmod) )  / 16.0);
	gl_FragColor = vec4( gl_FragColor.xyz * (f_diffuse_value + 0.4), 1.0 );
}