// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/lua/lua_raw.hh"

#include "nv/string.hh"

std::string nlua_typecontent( lua_State* L, int idx )
{
	switch ( lua_type( L, idx ) )
	{
	case LUA_TNONE          : return "NONE"; 
	case LUA_TNIL		    : return "NIL"; 
	case LUA_TBOOLEAN		: return lua_toboolean( L, idx ) == 0 ? "false" : "true"; 
	case LUA_TLIGHTUSERDATA	: return nv::to_string( nv::uint64( lua_touserdata( L, idx ) ) ); 
	case LUA_TNUMBER		: return nv::to_string( lua_tonumber( L, idx ) ); 
	case LUA_TSTRING		: return lua_tostring( L, idx ); 
	case LUA_TTABLE		    : return "TABLE"; 
	case LUA_TFUNCTION		: return "FUNCTION"; 
	case LUA_TUSERDATA		: return nv::to_string( nv::uint64( lua_touserdata( L, idx ) ) ); 
	case LUA_TTHREAD		: return "THREAD"; 
	default : return "UNKNOWN!"; 
	}
}

void nlua_shallowcopy( lua_State *L, int index )
{
	index = lua_absindex(L,index);
	lua_newtable(L);
	lua_pushnil(L);

	while ( lua_next( L, index ) != 0 )
	{
		lua_pushvalue(L, -2);
		lua_insert(L, -2);
		lua_settable(L, -4);
	}
}

void nlua_shallowmerge( lua_State *L, int index )
{
	index = lua_absindex(L,index);
	lua_pushnil(L);

	while( lua_next(L, index) != 0 )
	{
		lua_pushvalue(L, -2);
		lua_insert(L, -2);
		lua_rawset(L, -4);
	}
}

void nlua_deepcopy( lua_State *L, int index )
{
	index = lua_absindex(L,index);
	lua_newtable(L);
	lua_pushnil(L);

	while ( lua_next( L, index ) != 0 )
	{
		if ( lua_istable( L, -1 ) )
		{
			nlua_deepcopy( L, -1 );
			lua_insert( L, -2 );
			lua_pop( L, 1 );
		}
		lua_pushvalue(L, -2);
		lua_insert(L, -2);
		lua_settable(L, -4);
	}
}

