// Copyright (C) 2012-2013 Kornel Kisielewicz
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/gl/gl_window.hh"

#include "nv/logging.hh"
#include "nv/lib/gl.hh"
#include "nv/lib/sdl12.hh"

using namespace nv;

gl_window::gl_window( uint16 width, uint16 height )
	: m_width( width ), m_height( height ), m_title("NV Engine"), m_screen( nullptr )
{
	int flags = SDL_OPENGL;
	
	m_screen = SDL_SetVideoMode( width, height, 32, flags );
	
	if ( m_screen == 0 )
	{
		NV_LOG( LOG_CRITICAL, "Video mode set failed: " << SDL_GetError( ) );
		return; // TODO: Error report
	}

	nv::load_gl_library();
	NV_LOG( LOG_INFO, "OpenGL Vendor       : " << glGetString(GL_VENDOR) );
	NV_LOG( LOG_INFO, "OpenGL Renderer     : " << glGetString(GL_RENDERER) );
	NV_LOG( LOG_INFO, "OpenGL Version      : " << glGetString(GL_VERSION) );
	NV_LOG( LOG_INFO, "OpenGL GLSL Version : " << glGetString(GL_SHADING_LANGUAGE_VERSION) );

	m_context = new gl_context();
	m_context->set_viewport( nv::ivec4( 0, 0, m_width, m_height ) );
}

uint16 gl_window::get_width() const
{
	return m_width;
}

uint16 gl_window::get_height() const
{
	return m_height;
}

string gl_window::get_title() const
{
	return m_title;
}

void gl_window::set_title( const string& title )
{
	SDL_WM_SetCaption( title.c_str(), title.c_str() );
	m_title = title;
}

gl_window::~gl_window()
{
	delete m_context;
}
