// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
#ifndef NV_LUA_GLM_HH
#define NV_LUA_GLM_HH

#include <nv/common.hh>
#include <nv/lib/lua.hh>
#include <glm/glm.hpp>

void nlua_register_glm( lua_State* L );

template< typename T >
bool nlua_is_vec( lua_State* L, int index )
{
	return luaL_testudata( L, index, nv::get_type_name<T>() ) != 0;
}

template< typename T >
T nlua_to_vec( lua_State* L, int index )
{
	return *(T*)luaL_checkudata( L, index, nv::get_type_name<T>() );
}

template< typename T >
T* nlua_to_pvec( lua_State* L, int index )
{
	return (T*)luaL_checkudata( L, index, nv::get_type_name<T>() );
}

template< typename T >
void nlua_push_vec( lua_State* L, const T& v )
{
	new (lua_newuserdata(L, sizeof(T))) T(v);
	luaL_setmetatable( L, nv::get_type_name<T>() );
}

#endif // NV_LUA_GLM_HH
