if _ACTION == nil then
	print "Error! You must specify target build"
	print "Example: ./premake4 gmake"
	print "    This will create makefiles for Linux"
	print ""
	print "Aborting!"
	print ""
	return
end

solution "nv_render_test"
	configurations { "debug", "release" }

  	language "C++"
	flags { "ExtraWarnings", "NoPCH" }

	-- For starters, check the target build.
	-- If this is a gmake build we must add these
	-- flags to enable C++11 support.
	if _ACTION == "gmake" then
		buildoptions "-std=c++11"
	end

	configuration "debug"
		defines { "DEBUG" }
		flags { "Symbols", "StaticRuntime" }
		objdir (_ACTION.."/debug")

	configuration "release"
		defines { "NDEBUG" }
		flags { "Optimize", "StaticRuntime" }
		objdir (_ACTION.."/release")

	dofile("render_test.lua")
	dofile("../../nv.lua")

if _ACTION == "clean" then
	for action in premake.action.each() do
		os.rmdir(action.trigger)
	end
end
