// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/lib/lua.hh"

#if defined( NV_LUA_DYNAMIC )

#include "nv/library.hh"

/* State manipulation */
lua_State *        (*lua_newstate) (lua_Alloc f, void *ud) = nullptr;
void               (*lua_close) (lua_State *L) = nullptr;
lua_State *        (*lua_newthread) (lua_State *L) = nullptr;
lua_CFunction      (*lua_atpanic) (lua_State *L, lua_CFunction panicf) = nullptr;
const lua_Number * (*lua_version) (lua_State *L) = nullptr;

/* Basic stack manipulation */
int   (*lua_absindex) (lua_State *L, int idx) = nullptr;
int   (*lua_gettop) (lua_State *L) = nullptr;
void  (*lua_settop) (lua_State *L, int idx) = nullptr;
void  (*lua_pushvalue) (lua_State *L, int idx) = nullptr;
void  (*lua_remove) (lua_State *L, int idx) = nullptr;
void  (*lua_insert) (lua_State *L, int idx) = nullptr;
void  (*lua_replace) (lua_State *L, int idx) = nullptr;
void  (*lua_copy) (lua_State *L, int fromidx, int toidx) = nullptr;
int   (*lua_checkstack) (lua_State *L, int sz) = nullptr;
void  (*lua_xmove) (lua_State *from, lua_State *to, int n) = nullptr;

/* Access functions (stack -> C) */
int             (*lua_isnumber) (lua_State *L, int idx) = nullptr;
int             (*lua_isstring) (lua_State *L, int idx) = nullptr;
int             (*lua_iscfunction) (lua_State *L, int idx) = nullptr;
int             (*lua_isuserdata) (lua_State *L, int idx) = nullptr;
int             (*lua_type) (lua_State *L, int idx) = nullptr;
const char*     (*lua_typename) (lua_State *L, int tp) = nullptr;

lua_Number      (*lua_tonumberx) (lua_State *L, int idx, int *isnum) = nullptr;
lua_Integer     (*lua_tointegerx) (lua_State *L, int idx, int *isnum) = nullptr;
lua_Unsigned    (*lua_tounsignedx) (lua_State *L, int idx, int *isnum) = nullptr;
int             (*lua_toboolean) (lua_State *L, int idx) = nullptr;
const char*     (*lua_tolstring) (lua_State *L, int idx, size_t *len) = nullptr;
size_t          (*lua_rawlen) (lua_State *L, int idx) = nullptr;
lua_CFunction   (*lua_tocfunction) (lua_State *L, int idx) = nullptr;
void*           (*lua_touserdata) (lua_State *L, int idx) = nullptr;
lua_State*      (*lua_tothread) (lua_State *L, int idx) = nullptr;
const void*     (*lua_topointer) (lua_State *L, int idx) = nullptr;

/* Comparison and arithmetic functions */
void  (*lua_arith) (lua_State *L, int op) = nullptr;
int   (*lua_rawequal) (lua_State *L, int idx1, int idx2) = nullptr;
int   (*lua_compare) (lua_State *L, int idx1, int idx2, int op) = nullptr;

/* Push functions (C -> stack) */
void         (*lua_pushnil) (lua_State *L) = nullptr;
void         (*lua_pushnumber) (lua_State *L, lua_Number n) = nullptr;
void         (*lua_pushinteger) (lua_State *L, lua_Integer n) = nullptr;
void         (*lua_pushunsigned) (lua_State *L, lua_Unsigned n) = nullptr;
const char*  (*lua_pushlstring) (lua_State *L, const char *s, size_t l) = nullptr;
const char*  (*lua_pushstring) (lua_State *L, const char *s) = nullptr;
const char*  (*lua_pushvfstring) (lua_State *L, const char *fmt,
                                                      va_list argp) = nullptr;
const char * (*lua_pushfstring) (lua_State *L, const char *fmt, ...) = nullptr;
void  (*lua_pushcclosure) (lua_State *L, lua_CFunction fn, int n) = nullptr;
void  (*lua_pushboolean) (lua_State *L, int b) = nullptr;
void  (*lua_pushlightuserdata) (lua_State *L, void *p) = nullptr;
int   (*lua_pushthread) (lua_State *L) = nullptr;

/* Get functions (Lua -> stack) */
void  (*lua_getglobal) (lua_State *L, const char *var) = nullptr;
void  (*lua_gettable) (lua_State *L, int idx) = nullptr;
void  (*lua_getfield) (lua_State *L, int idx, const char *k) = nullptr;
void  (*lua_rawget) (lua_State *L, int idx) = nullptr;
void  (*lua_rawgeti) (lua_State *L, int idx, int n) = nullptr;
void  (*lua_rawgetp) (lua_State *L, int idx, const void *p) = nullptr;
void  (*lua_createtable) (lua_State *L, int narr, int nrec) = nullptr;
void* (*lua_newuserdata) (lua_State *L, size_t sz) = nullptr;
int   (*lua_getmetatable) (lua_State *L, int objindex) = nullptr;
void  (*lua_getuservalue) (lua_State *L, int idx) = nullptr;

/* Set functions (stack -> Lua) */
void  (*lua_setglobal) (lua_State *L, const char *var) = nullptr;
void  (*lua_settable) (lua_State *L, int idx) = nullptr;
void  (*lua_setfield) (lua_State *L, int idx, const char *k) = nullptr;
void  (*lua_rawset) (lua_State *L, int idx) = nullptr;
void  (*lua_rawseti) (lua_State *L, int idx, int n) = nullptr;
void  (*lua_rawsetp) (lua_State *L, int idx, const void *p) = nullptr;
int   (*lua_setmetatable) (lua_State *L, int objindex) = nullptr;
void  (*lua_setuservalue) (lua_State *L, int idx) = nullptr;

/* 'load' and 'call' functions (load and run Lua code) */
void  (*lua_callk) (lua_State *L, int nargs, int nresults, int ctx, lua_CFunction k) = nullptr;
int   (*lua_getctx) (lua_State *L, int *ctx) = nullptr;
int   (*lua_pcallk) (lua_State *L, int nargs, int nresults, int errfunc, int ctx, lua_CFunction k) = nullptr;
int   (*lua_load) (lua_State *L, lua_Reader reader, void *dt, const char *chunkname, const char *mode) = nullptr;
int   (*lua_dump) (lua_State *L, lua_Writer writer, void *data) = nullptr;

/* Coroutine functions */
int  (*lua_yieldk) (lua_State *L, int nresults, int ctx, lua_CFunction k) = nullptr;
int  (*lua_resume) (lua_State *L, lua_State *from, int narg) = nullptr;
int  (*lua_status) (lua_State *L) = nullptr;

/* Garbage-collection function and options */
int (*lua_gc) (lua_State *L, int what, int data) = nullptr;

/* Miscellaneous functions */
int   (*lua_error) (lua_State *L) = nullptr;
int   (*lua_next) (lua_State *L, int idx) = nullptr;
void  (*lua_concat) (lua_State *L, int n) = nullptr;
void  (*lua_len)    (lua_State *L, int idx) = nullptr;
lua_Alloc (*lua_getallocf) (lua_State *L, void **ud) = nullptr;
void      (*lua_setallocf) (lua_State *L, lua_Alloc f, void *ud) = nullptr;

/* Debug API */
int (*lua_getstack) (lua_State *L, int level, lua_Debug *ar) = nullptr;
int (*lua_getinfo) (lua_State *L, const char *what, lua_Debug *ar) = nullptr;
const char * (*lua_getlocal) (lua_State *L, const lua_Debug *ar, int n) = nullptr;
const char * (*lua_setlocal) (lua_State *L, const lua_Debug *ar, int n) = nullptr;
const char * (*lua_getupvalue) (lua_State *L, int funcindex, int n) = nullptr;
const char * (*lua_setupvalue) (lua_State *L, int funcindex, int n) = nullptr;
void * (*lua_upvalueid) (lua_State *L, int fidx, int n) = nullptr;
void   (*lua_upvaluejoin) (lua_State *L, int fidx1, int n1, int fidx2, int n2) = nullptr;
int (*lua_sethook) (lua_State *L, lua_Hook func, int mask, int count) = nullptr;
lua_Hook (*lua_gethook) (lua_State *L) = nullptr;
int (*lua_gethookmask) (lua_State *L) = nullptr;
int (*lua_gethookcount) (lua_State *L) = nullptr;

/* lualib API */
int (*luaopen_base) (lua_State *L) = nullptr;
int (*luaopen_coroutine) (lua_State *L) = nullptr;
int (*luaopen_table) (lua_State *L) = nullptr;
int (*luaopen_io) (lua_State *L) = nullptr;
int (*luaopen_os) (lua_State *L) = nullptr;
int (*luaopen_string) (lua_State *L) = nullptr;
int (*luaopen_bit32) (lua_State *L) = nullptr;
int (*luaopen_math) (lua_State *L) = nullptr;
int (*luaopen_debug) (lua_State *L) = nullptr;
int (*luaopen_package) (lua_State *L) = nullptr;
int (*luaL_openlibs) (lua_State *L) = nullptr;

/* lauxlib API */
void   (*luaL_checkversion_) (lua_State *L, lua_Number ver) = nullptr;
int  (*luaL_getmetafield) (lua_State *L, int obj, const char *e) = nullptr;
int  (*luaL_callmeta) (lua_State *L, int obj, const char *e) = nullptr;
const char * (*luaL_tolstring) (lua_State *L, int idx, size_t *len) = nullptr;
int  (*luaL_argerror) (lua_State *L, int numarg, const char *extramsg) = nullptr;
const char * (*luaL_checklstring) (lua_State *L, int numArg, size_t *l) = nullptr;
const char * (*luaL_optlstring) (lua_State *L, int numArg, const char *def, size_t *l) = nullptr;
lua_Number  (*luaL_checknumber) (lua_State *L, int numArg) = nullptr;
lua_Number  (*luaL_optnumber) (lua_State *L, int nArg, lua_Number def) = nullptr;
lua_Integer  (*luaL_checkinteger) (lua_State *L, int numArg) = nullptr;
lua_Integer  (*luaL_optinteger) (lua_State *L, int nArg, lua_Integer def) = nullptr;
lua_Unsigned  (*luaL_checkunsigned) (lua_State *L, int numArg) = nullptr;
lua_Unsigned  (*luaL_optunsigned) (lua_State *L, int numArg, lua_Unsigned def) = nullptr;
void  (*luaL_checkstack) (lua_State *L, int sz, const char *msg) = nullptr;
void  (*luaL_checktype) (lua_State *L, int narg, int t) = nullptr;
void  (*luaL_checkany) (lua_State *L, int narg) = nullptr;
int    (*luaL_newmetatable) (lua_State *L, const char *tname) = nullptr;
void   (*luaL_setmetatable) (lua_State *L, const char *tname) = nullptr;
void * (*luaL_testudata) (lua_State *L, int ud, const char *tname) = nullptr;
void * (*luaL_checkudata) (lua_State *L, int ud, const char *tname) = nullptr;
void  (*luaL_where) (lua_State *L, int lvl) = nullptr;
int  (*luaL_error) (lua_State *L, const char *fmt, ...) = nullptr;
int  (*luaL_checkoption) (lua_State *L, int narg, const char *def, const char *const lst[]) = nullptr;
int  (*luaL_fileresult) (lua_State *L, int stat, const char *fname) = nullptr;
int  (*luaL_execresult) (lua_State *L, int stat) = nullptr;

int  (*luaL_ref) (lua_State *L, int t) = nullptr;
void  (*luaL_unref) (lua_State *L, int t, int ref) = nullptr;
int  (*luaL_loadfilex) (lua_State *L, const char *filename, const char *mode) = nullptr;
int  (*luaL_loadbufferx) (lua_State *L, const char *buff, size_t sz, const char *name, const char *mode) = nullptr;
int  (*luaL_loadstring) (lua_State *L, const char *s) = nullptr;
lua_State * (*luaL_newstate)  (void) = nullptr;
int  (*luaL_len) (lua_State *L, int idx) = nullptr;
const char * (*luaL_gsub) (lua_State *L, const char *s, const char *p, const char *r) = nullptr;
void  (*luaL_setfuncs) (lua_State *L, const luaL_Reg *l, int nup) = nullptr;
int  (*luaL_getsubtable) (lua_State *L, int idx, const char *fname) = nullptr;
void  (*luaL_traceback) (lua_State *L, lua_State *L1, const char *msg, int level) = nullptr;
void  (*luaL_requiref) (lua_State *L, const char *modname, lua_CFunction openf, int glb) = nullptr;

bool nv::load_lua_library( const char* path )
{
#	define NV_LUA_LOAD( symbol ) *(void **) (&symbol) = lua_library.get(#symbol);

	static nv::library lua_library( path );

/* State manipulation */
	NV_LUA_LOAD(lua_newstate);
	NV_LUA_LOAD(lua_close);
	NV_LUA_LOAD(lua_newthread);
	NV_LUA_LOAD(lua_atpanic);
	NV_LUA_LOAD(lua_version);

/* Basic stack manipulation */
	NV_LUA_LOAD(lua_absindex);
	NV_LUA_LOAD(lua_gettop);
	NV_LUA_LOAD(lua_settop);
	NV_LUA_LOAD(lua_pushvalue);
	NV_LUA_LOAD(lua_remove);
	NV_LUA_LOAD(lua_insert);
	NV_LUA_LOAD(lua_replace);
	NV_LUA_LOAD(lua_copy);
	NV_LUA_LOAD(lua_checkstack);
	NV_LUA_LOAD(lua_xmove);

/* Access functions (stack -> C) */
	NV_LUA_LOAD(lua_isnumber);
	NV_LUA_LOAD(lua_isstring);
	NV_LUA_LOAD(lua_iscfunction);
	NV_LUA_LOAD(lua_isuserdata);
	NV_LUA_LOAD(lua_type);
	NV_LUA_LOAD(lua_typename);

	NV_LUA_LOAD(lua_tonumberx);
	NV_LUA_LOAD(lua_tointegerx);
	NV_LUA_LOAD(lua_tounsignedx);
	NV_LUA_LOAD(lua_toboolean);
	NV_LUA_LOAD(lua_tolstring);
	NV_LUA_LOAD(lua_rawlen);
	NV_LUA_LOAD(lua_tocfunction);
	NV_LUA_LOAD(lua_touserdata);
	NV_LUA_LOAD(lua_tothread);
	NV_LUA_LOAD(lua_topointer);

/* Comparison and arithmetic functions */
	NV_LUA_LOAD(lua_arith);
	NV_LUA_LOAD(lua_rawequal);
	NV_LUA_LOAD(lua_compare);

/* Push functions (C -> stack) */
	NV_LUA_LOAD(lua_pushnil);
	NV_LUA_LOAD(lua_pushnumber);
	NV_LUA_LOAD(lua_pushinteger);
	NV_LUA_LOAD(lua_pushunsigned);
	NV_LUA_LOAD(lua_pushlstring);
	NV_LUA_LOAD(lua_pushstring);
	NV_LUA_LOAD(lua_pushvfstring);
	NV_LUA_LOAD(lua_pushfstring);
	NV_LUA_LOAD(lua_pushcclosure);
	NV_LUA_LOAD(lua_pushboolean);
	NV_LUA_LOAD(lua_pushlightuserdata);
	NV_LUA_LOAD(lua_pushthread);

/* Get functions (Lua -> stack) */
	NV_LUA_LOAD(lua_getglobal);
	NV_LUA_LOAD(lua_gettable);
	NV_LUA_LOAD(lua_getfield);
	NV_LUA_LOAD(lua_rawget);
	NV_LUA_LOAD(lua_rawgeti);
	NV_LUA_LOAD(lua_rawgetp);
	NV_LUA_LOAD(lua_createtable);
	NV_LUA_LOAD(lua_newuserdata);
	NV_LUA_LOAD(lua_getmetatable);
	NV_LUA_LOAD(lua_getuservalue);

/* Set functions (stack -> Lua) */
	NV_LUA_LOAD(lua_setglobal);
	NV_LUA_LOAD(lua_settable);
	NV_LUA_LOAD(lua_setfield);
	NV_LUA_LOAD(lua_rawset);
	NV_LUA_LOAD(lua_rawseti);
	NV_LUA_LOAD(lua_rawsetp);
	NV_LUA_LOAD(lua_setmetatable);
	NV_LUA_LOAD(lua_setuservalue);

/* 'load' and 'call' functions (load and run Lua code) */
	NV_LUA_LOAD(lua_callk);
	NV_LUA_LOAD(lua_getctx);
	NV_LUA_LOAD(lua_pcallk);
	NV_LUA_LOAD(lua_load);
	NV_LUA_LOAD(lua_dump);

/* Coroutine functions */
	NV_LUA_LOAD(lua_yieldk);
	NV_LUA_LOAD(lua_resume);
	NV_LUA_LOAD(lua_status);

/* Garbage-collection function and options */
	NV_LUA_LOAD(lua_gc);

/* Miscellaneous functions */
	NV_LUA_LOAD(lua_error);
	NV_LUA_LOAD(lua_next);
	NV_LUA_LOAD(lua_concat);
	NV_LUA_LOAD(lua_len);
	NV_LUA_LOAD(lua_getallocf);
	NV_LUA_LOAD(lua_setallocf);

/* Debug API */
	NV_LUA_LOAD(lua_getstack);
	NV_LUA_LOAD(lua_getinfo);
	NV_LUA_LOAD(lua_getlocal);
	NV_LUA_LOAD(lua_setlocal);
	NV_LUA_LOAD(lua_getupvalue);
	NV_LUA_LOAD(lua_setupvalue);
	NV_LUA_LOAD(lua_upvalueid);
	NV_LUA_LOAD(lua_upvaluejoin);
	NV_LUA_LOAD(lua_sethook);
	NV_LUA_LOAD(lua_gethook);
	NV_LUA_LOAD(lua_gethookmask);
	NV_LUA_LOAD(lua_gethookcount);

/* lualib API */
	NV_LUA_LOAD(luaopen_base);
	NV_LUA_LOAD(luaopen_coroutine);
	NV_LUA_LOAD(luaopen_table);
	NV_LUA_LOAD(luaopen_io);
	NV_LUA_LOAD(luaopen_os);
	NV_LUA_LOAD(luaopen_string);
	NV_LUA_LOAD(luaopen_bit32);
	NV_LUA_LOAD(luaopen_math);
	NV_LUA_LOAD(luaopen_debug);
	NV_LUA_LOAD(luaopen_package);
	NV_LUA_LOAD(luaL_openlibs);

/* lauxlib API */
	NV_LUA_LOAD(luaL_checkversion_);
	NV_LUA_LOAD(luaL_getmetafield);
	NV_LUA_LOAD(luaL_callmeta);
	NV_LUA_LOAD(luaL_tolstring);
	NV_LUA_LOAD(luaL_argerror);
	NV_LUA_LOAD(luaL_checklstring);
	NV_LUA_LOAD(luaL_optlstring);
	NV_LUA_LOAD(luaL_checknumber);
	NV_LUA_LOAD(luaL_optnumber);
	NV_LUA_LOAD(luaL_checkinteger);
	NV_LUA_LOAD(luaL_optinteger);
	NV_LUA_LOAD(luaL_checkunsigned);
	NV_LUA_LOAD(luaL_optunsigned);
	NV_LUA_LOAD(luaL_checkstack);
	NV_LUA_LOAD(luaL_checktype);
	NV_LUA_LOAD(luaL_checkany);
	NV_LUA_LOAD(luaL_newmetatable);
	NV_LUA_LOAD(luaL_setmetatable);
	NV_LUA_LOAD(luaL_testudata);
	NV_LUA_LOAD(luaL_checkudata);
	NV_LUA_LOAD(luaL_where);
	NV_LUA_LOAD(luaL_error);
	NV_LUA_LOAD(luaL_checkoption);
	NV_LUA_LOAD(luaL_fileresult);
	NV_LUA_LOAD(luaL_execresult);

	NV_LUA_LOAD(luaL_ref);
	NV_LUA_LOAD(luaL_unref);
	NV_LUA_LOAD(luaL_loadfilex);
	NV_LUA_LOAD(luaL_loadbufferx);
	NV_LUA_LOAD(luaL_loadstring);
	NV_LUA_LOAD(luaL_newstate);
	NV_LUA_LOAD(luaL_len);
	NV_LUA_LOAD(luaL_gsub);
	NV_LUA_LOAD(luaL_setfuncs);
	NV_LUA_LOAD(luaL_getsubtable);
	NV_LUA_LOAD(luaL_traceback);
	NV_LUA_LOAD(luaL_requiref);

#	undef NV_LUA_LOAD
	return true;
}

#endif
