#version 120
attribute vec3 nv_position;
attribute vec3 nv_color;
uniform mat4 nv_m_mvp;

varying vec3 f_coord;
varying vec3 f_normal;
varying vec3 f_material;
varying float f_diffuse_value;
uniform vec3 light;

void main(void) {
	f_normal = vec3(0,0,0);
	f_normal[int(abs(nv_color.y)-1)] = sign( nv_color.y );
	vec3 vnormal  = normalize(f_normal);
	vec3 vlight   = normalize(light - nv_position);
	float diffuse = max(dot(vlight, vnormal), 0.0);
	f_diffuse_value = diffuse;
	f_coord = nv_position;
	f_material = nv_color;
	gl_Position = nv_m_mvp * vec4(nv_position, 1.0);
}
