// Copyright (C) 2016-2016 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#include "nv/lua/lua_gfx.hh"

#include "nv/base/capi.hh"
#include "nv/lua/lua_raw.hh"
#include "nv/lua/lua_templates.hh"

using nv::lua::detail::is_color_mask;
using nv::lua::detail::to_color_mask;
using nv::lua::detail::to_pcolor_mask;
using nv::lua::detail::push_color_mask;

using nv::lua::detail::is_scissor_test;
using nv::lua::detail::to_scissor_test;
using nv::lua::detail::to_pscissor_test;
using nv::lua::detail::push_scissor_test;

using nv::lua::detail::is_clear_state;
using nv::lua::detail::to_clear_state;
using nv::lua::detail::to_pclear_state;
using nv::lua::detail::push_clear_state;

static int nlua_color_mask_tostring( lua_State * L )
{
	nv::color_mask* m = to_pcolor_mask( L, 1 );
	lua_pushfstring( L, "color_mask(%s%s%s%s)",
		m->red ? "R" : "-",
		m->red ? "G" : "-",
		m->red ? "B" : "-",
		m->red ? "A" : "-"
	);
	return 1;
}

static int nlua_color_mask_index( lua_State * L )
{
	nv::color_mask* m = to_pcolor_mask( L, 1 );
	size_t len = 0;
	const char * key = lua_tolstring( L, 2, &len );
	if ( len > 0 )
	{
		char k = key[0];
		if ( k == 'r' && ( len == 1 || nv::nvstrcmp( key, "red" ) == 0 ) )
		{
			lua_pushboolean( L, m->red ); return 1;
		}
		if ( k == 'g' && ( len == 1 || nv::nvstrcmp( key, "green" ) == 0 ) )
		{
			lua_pushboolean( L, m->green ); return 1;
		}
		if ( k == 'b' && ( len == 1 || nv::nvstrcmp( key, "blue" ) == 0 ) )
		{
			lua_pushboolean( L, m->blue ); return 1;
		}
		if ( k == 'a' && ( len == 1 || nv::nvstrcmp( key, "alpha" ) == 0 ) )
		{
			lua_pushboolean( L, m->alpha ); return 1;
		}
	}

	luaL_getmetafield( L, 1, "__functions" );
	lua_pushvalue( L, 2 );
	lua_rawget( L, -2 );
	return 1;
}

static int nlua_color_mask_newindex( lua_State * L )
{
	nv::color_mask* m = to_pcolor_mask( L, 1 );
	size_t len = 0;
	const char * key = lua_tolstring( L, 2, &len );
	if ( len > 0 )
	{
		char k = key[0];
		if ( k == 'r' && ( len == 1 || nv::nvstrcmp( key, "red" ) == 0 ) )
		{
			m->red   = lua_toboolean( L, 3 ) != 0; return 0;
		}
		if ( k == 'g' && ( len == 1 || nv::nvstrcmp( key, "green" ) == 0 ) )
		{
			m->green = lua_toboolean( L, 3 ) != 0; return 0;
		}
		if ( k == 'b' && ( len == 1 || nv::nvstrcmp( key, "blue" ) == 0 ) )
		{
			m->blue  = lua_toboolean( L, 3 ) != 0; return 0;
		}
		if ( k == 'a' && ( len == 1 || nv::nvstrcmp( key, "alpha" ) == 0 ) )
		{
			m->alpha = lua_toboolean( L, 3 ) != 0; return 0;
		}
	}
	luaL_error( L, "color_mask : unknown index - %s", lua_tostring( L, 2 ) );
	return 0;
}

static int luaopen_color_mask( lua_State * L )
{
	struct constructor
	{
		static inline nv::color_mask construct( lua_State* L, int index )
		{
			int args = lua_gettop( L ) - index;
			bool r = args >= 0 ? lua_toboolean( L, index + 0 ) != 0 : true;
			bool g = args >= 1 ? lua_toboolean( L, index + 1 ) != 0 : true;
			bool b = args >= 2 ? lua_toboolean( L, index + 2 ) != 0 : true;
			bool a = args >= 3 ? lua_toboolean( L, index + 3 ) != 0 : true;
			return nv::color_mask( r, g, b, a );
		}
	};

	NV_LUA_STACK_ASSERT( L, 1 );
	static const struct luaL_Reg nlua_color_mask_sf[] = {
		{ "new",            nv::lua::detail::new_impl<nv::color_mask, constructor> },
		{ NULL, NULL }
	};

	static const struct luaL_Reg nlua_color_mask_f[] = {
		{ "clone",          nv::lua::detail::clone_impl<nv::color_mask> },
		{ "tostring",       nlua_color_mask_tostring },
		{ NULL, NULL }
	};

	static const struct luaL_Reg nlua_color_mask_sm[] = {
		{ "__call",          nv::lua::detail::call_impl<nv::color_mask, constructor> },
		{ NULL, NULL }
	};

	static const struct luaL_Reg nlua_color_mask_m[] = {
		{ "__eq",       nv::lua::detail::eq_impl<nv::color_mask> },
		{ "__index",    nlua_color_mask_index },
		{ "__newindex", nlua_color_mask_newindex },
		{ "__tostring", nlua_color_mask_tostring },
		{ NULL, NULL }
	};

	luaL_newmetatable( L, nv::lua::pass_traits<nv::color_mask>::metatable() );
	nlua_register( L, nlua_color_mask_m, -1 );
	lua_createtable( L, 0, 0 );
	nlua_register( L, nlua_color_mask_f, -1 );
	lua_setfield( L, -2, "__functions" );
	lua_pop( L, 1 );

	lua_createtable( L, 0, 0 );
	nlua_register( L, nlua_color_mask_sf, -1 );
	lua_createtable( L, 0, 0 );
	nlua_register( L, nlua_color_mask_sm, -1 );
	lua_setmetatable( L, -2 );

// 	nv::lua::detail::push_vec( L, T() );
// 	lua_setfield( L, -2, "ZERO" );
// 	nv::lua::detail::push_vec( L, nlua_vec_constructor<T, sizeof( T ) / sizeof( typename T::value_type )>::unit() );
// 	lua_setfield( L, -2, "UNIT" );

	return 1;
}

static int luaopen_scissor_test( lua_State * L )
{
	NV_LUA_STACK_ASSERT( L, 1 );
	return 1;
}

static int luaopen_clear_state( lua_State * L )
{
	NV_LUA_STACK_ASSERT( L, 1 );
	return 1;
}


void nv::lua::register_gfx( lua_State* L )
{
	int stack = lua_gettop( L );
	nlua_requiref( L, "color_mask", luaopen_color_mask, 1 );
	nlua_requiref( L, "scissor_test", luaopen_scissor_test, 1 );
	nlua_requiref( L, "clear_state", luaopen_clear_state, 1 );
	lua_settop( L, stack );
}
