// Copyright (C) 2017-2017 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
* @file enumerator.hh
* @author Kornel Kisielewicz epyon@chaosforge.org
* @brief enumerator support
*/

#ifndef NV_STL_ENUMERATOR_HH
#define NV_STL_ENUMERATOR_HH

#include <nv/common.hh>
#include <nv/stl/math.hh>
#include <nv/stl/iterator.hh>
#include <nv/stl/type_traits/transforms.hh>

namespace nv
{

	template < typename T >
	class value_enumerator_base : public iterator< input_iterator_tag, T >
	{
	public:
		value_enumerator_base( T value ) : m_value( value ) {}
		T operator* () const { return m_value; }
		T const* operator-> () const { return &m_value; }
		bool operator== ( const value_enumerator_base& rhs ) const
		{
			return m_value == rhs.m_value;
		}
		bool operator!= ( const value_enumerator_base& rhs ) const
		{
			return !( *this == rhs );
		}
	protected:
		T m_value;
	};


	template < typename Enumerator >
	class enumerator_provider
	{
	public:
		enumerator_provider( Enumerator begin, Enumerator end )
			: m_begin( begin ), m_end( end ) {}
		Enumerator begin() const { return m_begin; }
		Enumerator end() const { return m_end; }
	protected:
		Enumerator m_begin;
		Enumerator m_end;
	};
		
}

#endif // NV_STL_ENUMERATOR_HH
