// Copyright (C) 2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file function.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief type traits - function traits
 */
// TODO: remove_cv? call traits? 

#ifndef NV_STL_TRAITS_FUNCTION_HH
#define NV_STL_TRAITS_FUNCTION_HH

#include <nv/stl/type_traits/common.hh>

namespace nv
{

	namespace detail
	{

		template < typename F >
		struct function_traits_impl
		{

		};

		template < typename R >
		struct function_traits_impl < R( *)( void ) >
		{
			typedef R( *type )( );
			typedef R        return_type;
			typedef void     class_type;
			static constexpr int arg_count = 0;
		};

		template < typename R, typename... Args >
		struct function_traits_impl < R( *)( Args... ) >
		{
			typedef R( *type )( Args... );
			typedef R        return_type;
			typedef void     class_type;
			static constexpr int arg_count = sizeof...( Args );
		};

		template < class C, typename R >
		struct function_traits_impl < R( C::* )( ) >
		{
			typedef R( *type )( );
			typedef R       return_type;
			typedef C       class_type;
			static constexpr int arg_count = 0;
		};

		template < class C, typename R, typename... Args >
		struct function_traits_impl < R( C::* )( Args... ) >
		{
			typedef R( C::*type )( Args... );
			typedef R        return_type;
			typedef C        class_type;
			static constexpr int arg_count = sizeof...( Args );
		};

	}

	template < typename F >
	struct function_traits : detail::function_traits_impl < F >
	{

	};

	template < typename T >
	struct return_type
	{
		typedef typename function_traits< T >::return_type type;
	};
	template < typename T >
	using return_type_t = typename return_type<T>::type;

	template < typename T >
	struct memfn_class_type
	{
		typedef typename function_traits< T >::class_type type;
	};
	template < typename T >
	using memfn_class_type_t = typename memfn_class_type<T>::type;

	// Substitute with the solution in type_traits/experimental.hh once
	// that one is confirmed safe
	NV_GENERATE_HAS_TYPE_SAFE( result_type )

	namespace detail
	{
		template < bool Exists, typename T > struct extract_result_type {};
		template < typename T >
		struct extract_result_type< true, T >
		{
			typedef typename T::result_type result_type;
		};

		template < typename T >
		struct weak_result_type_impl : extract_result_type< has_result_type<T>::value, T > {};

// TODO: see if const volatile are needed under MSVC - we remove them after all
#if NV_COMPILER == NV_MSVC && NV_ARCHITECTURE == NV_32BIT
#define NV_EMIT_WEAK_RESULT_TYPE_CALLDECL( CALLDECL ) \
		template < typename R, typename... Args > struct weak_result_type_impl< R CALLDECL( Args... ) > { typedef R result_type; }; \
		template < typename R, typename... Args > struct weak_result_type_impl< R( CALLDECL & )( Args... ) > { typedef R result_type; }; \
		template < typename R, typename... Args > struct weak_result_type_impl< R( CALLDECL * )( Args... ) > { typedef R result_type; }; \
		template < typename R, typename C, typename... Args > struct weak_result_type_impl< R( CALLDECL C::* )( Args... ) > { typedef R result_type; }; \
		template < typename R, typename C, typename... Args > struct weak_result_type_impl< R( CALLDECL C::* )( Args... ) const > { typedef R result_type; }; \
		template < typename R, typename C, typename... Args > struct weak_result_type_impl< R( CALLDECL C::* )( Args... ) volatile > { typedef R result_type; }; \
		template < typename R, typename C, typename... Args > struct weak_result_type_impl< R( CALLDECL C::* )( Args... ) const volatile > { typedef R result_type; }; \
		
//NV_EMIT_WEAK_RESULT_TYPE_CALLDECL()
NV_EMIT_WEAK_RESULT_TYPE_CALLDECL( __cdecl )
NV_EMIT_WEAK_RESULT_TYPE_CALLDECL( __fastcall )
NV_EMIT_WEAK_RESULT_TYPE_CALLDECL( __vectorcall )
template < typename R, typename... Args > struct weak_result_type_impl< R __cdecl ( Args..., ... ) > { typedef R result_type; }; \
template < typename R, typename... Args > struct weak_result_type_impl< R( __cdecl & )( Args..., ... ) > { typedef R result_type; }; \
template < typename R, typename... Args > struct weak_result_type_impl< R( __cdecl * )( Args..., ... ) > { typedef R result_type; }; \
template < typename R, typename C, typename... Args > struct weak_result_type_impl< R( __cdecl C::* )( Args..., ... ) > { typedef R result_type; }; \
template < typename R, typename C, typename... Args > struct weak_result_type_impl< R( __cdecl C::* )( Args..., ... ) const > { typedef R result_type; }; \
template < typename R, typename C, typename... Args > struct weak_result_type_impl< R( __cdecl C::* )( Args..., ... ) volatile > { typedef R result_type; }; \
template < typename R, typename C, typename... Args > struct weak_result_type_impl< R( __cdecl C::* )( Args..., ... ) const volatile > { typedef R result_type; }; \

#	if NV_ARCHITECTURE == NV_32BIT
NV_EMIT_WEAK_RESULT_TYPE_CALLDECL( __stdcall )
template < typename R, typename C, typename... Args > struct weak_result_type_impl< R( __thiscall C::* )( Args... ) > { typedef R result_type; };
template < typename R, typename C, typename... Args > struct weak_result_type_impl< R( __thiscall C::* )( Args... ) const > { typedef R result_type; }; 
template < typename R, typename C, typename... Args > struct weak_result_type_impl< R( __thiscall C::* )( Args... ) volatile > { typedef R result_type; }; 
template < typename R, typename C, typename... Args > struct weak_result_type_impl< R( __thiscall C::* )( Args... ) const volatile > { typedef R result_type; };
#	endif
#undef NV_EMIT_WEAK_RESULT_TYPE_CALLDECL
#else
		template < typename R, typename... Args > struct weak_result_type_impl< R( Args... ) > { typedef R result_type; };
		template < typename R, typename... Args > struct weak_result_type_impl< R( Args..., ... ) > { typedef R result_type; };
		template < typename R, typename... Args > struct weak_result_type_impl< R( Args... ) const > { typedef R result_type; };
		template < typename R, typename... Args > struct weak_result_type_impl< R( Args..., ... ) const > { typedef R result_type; };
		template < typename R, typename... Args > struct weak_result_type_impl< R( Args... ) volatile > { typedef R result_type; };
		template < typename R, typename... Args > struct weak_result_type_impl< R( Args..., ... ) volatile > { typedef R result_type; };
		template < typename R, typename... Args > struct weak_result_type_impl< R( Args... ) const volatile > { typedef R result_type; };
		template < typename R, typename... Args > struct weak_result_type_impl< R( Args..., ... ) const volatile > { typedef R result_type; };
		template < typename R, typename... Args > struct weak_result_type_impl< R( & )( Args... ) > { typedef R result_type; };
		template < typename R, typename... Args > struct weak_result_type_impl< R( & )( Args..., ... ) > { typedef R result_type; };
		template < typename R, typename... Args > struct weak_result_type_impl< R( * )( Args... ) > { typedef R result_type; };
		template < typename R, typename... Args > struct weak_result_type_impl< R( * )( Args..., ... ) > { typedef R result_type; };
		template < typename R, typename C, typename... Args > struct weak_result_type_impl< R( C::* )( Args... ) > { typedef R result_type; };
		template < typename R, typename C, typename... Args > struct weak_result_type_impl< R( C::* )( Args..., ... ) > { typedef R result_type; };
		template < typename R, typename C, typename... Args > struct weak_result_type_impl< R( C::* )( Args... ) const > { typedef R result_type; };
		template < typename R, typename C, typename... Args > struct weak_result_type_impl< R( C::* )( Args..., ... ) const > { typedef R result_type; };
		template < typename R, typename C, typename... Args > struct weak_result_type_impl< R( C::* )( Args... ) volatile > { typedef R result_type; };
		template < typename R, typename C, typename... Args > struct weak_result_type_impl< R( C::* )( Args..., ... ) volatile > { typedef R result_type; };
		template < typename R, typename C, typename... Args > struct weak_result_type_impl< R( C::* )( Args... ) const volatile > { typedef R result_type; };
		template < typename R, typename C, typename... Args > struct weak_result_type_impl< R( C::* )( Args..., ... ) const volatile > { typedef R result_type; };
#endif
	}

	template < typename T >
	struct weak_result_type : detail::weak_result_type_impl< remove_cv_t< T > > {};


}

#endif // NV_STL_TRAITS_FUNCTION_HH
