// Copyright (C) 2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
* @file string_map.hh
* @author Kornel Kisielewicz epyon@chaosforge.org
* @brief string_map and literal_map
*/

#ifndef NV_STL_STRING_MAP_HH
#define NV_STL_STRING_MAP_HH

#include <nv/common.hh>
#include <nv/stl/string.hh>
#include <nv/stl/container/hash_table.hh>
#include <nv/stl/utility/pair.hh>
#include <nv/stl/hash_map.hh>

namespace nv
{

	template < typename T >
	using literal_map = hash_map<
		hashed_literal_string_64, T, uint64, 
		hash_map_entry_policy< hashed_literal_string_64, hashed_literal_string_64, T, uint64, false, true >,
		is_string_base
	>;

	template < typename T >
	using string_map = hash_map<
		const_string, T, uint64,
		hash_map_entry_policy< const_string, string_view, T, uint64, true, true >,
		hash_table_no_extra_types_policy,
		is_string_base
	>;

}

#endif // NV_STL_STRING_MAP_HH

