// Copyright (C) 2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file rtti_types.hh
 * @author Kornel Kisielewicz
 * @brief RTTI emulation - basic types
 */

#ifndef NV_STL_RTTI_TYPES_HH
#define NV_STL_RTTI_TYPES_HH

#include <nv/common.hh>

NV_RTTI_DECLARE( void )
NV_RTTI_DECLARE( bool )
NV_RTTI_DECLARE( char )
NV_RTTI_DECLARE_NAME( nv::sint8, "sint8" )
NV_RTTI_DECLARE_NAME( nv::uint8, "uint8" )
NV_RTTI_DECLARE_NAME( nv::sint16, "sint16" )
NV_RTTI_DECLARE_NAME( nv::uint16, "uint16" )
NV_RTTI_DECLARE_NAME( nv::sint32, "sint32" )
NV_RTTI_DECLARE_NAME( nv::uint32, "uint32" )
NV_RTTI_DECLARE_NAME( nv::sint64, "sint64" )
NV_RTTI_DECLARE_NAME( nv::uint64, "uint64" )
NV_RTTI_DECLARE_NAME( nv::f32, "f32" )
NV_RTTI_DECLARE_NAME( nv::f64, "f64" )

#endif // NV_STL_RTTI_TYPES_HH
