// Copyright (C) 2016 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
* @file list.hh
* @author Kornel Kisielewicz epyon@chaosforge.org
* @brief STL/MPL list 
*/

#ifndef NV_STL_MPL_LIST_HH
#define NV_STL_MPL_LIST_HH

#include <nv/common.hh>
#include <nv/stl/type_traits.hh>

namespace nv
{
	namespace mpl
	{

		template < typename... Ts > struct list {};

		template < typename T, T... Values >
		using integral_list = mpl::list< integral_constant< T, Values >... >;

		using empty_list = mpl::list<>;

		namespace detail
		{

// 			template < typename... Ts >
// 			struct append_impl
// 			{
// 				typedef mpl::empty_list type;
// 			};
// 
// 			template < typename T >
// 			struct append_impl< T >
// 			{
// 				typedef T type;
// 			};
// 
// 			template < 
// 				typename < typename... > class L1,
// 				typename < typename... > class L2,
// 				typename... T1s,
// 				typename... T2s,
// 				typename... Ts 
// 			>
// 			struct append_impl< L1< T1s... >, L2< T2s... >, Ts... >
// 				: append_impl< L1< T1s..., T2s... >, Ts... >
// 			{
// 			};

			template< typename T > struct list_size_impl;

			template< typename... T> struct list_size_impl< list<T...> >
			{
				using type = nv::integral_constant< uint32, sizeof...( T )>;
			};

			template< typename T > struct head_impl;

			template< typename H, typename... T> struct head_impl< list<H,T...> >
			{
				using type = H;
			};

		}

		template< typename List > 
		using list_size = typename detail::list_size_impl<List>::type;

		template< typename List >
		using head = typename detail::head_impl<List>::type;
		
// 		template < typename... Ts >
// 		using append = detail::append_impl< Ts... >::type;


	}
}

#endif // NV_STL_MPL_LIST_HH
