// Copyright (C) 2015-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
* @file trigonometric.hh
* @author Kornel Kisielewicz epyon@chaosforge.org
* @brief relational math ops
*/

#ifndef NV_STL_MATH_TRIGONOMETRIC_HH
#define NV_STL_MATH_TRIGONOMETRIC_HH

#include <nv/stl/math/common.hh>

namespace nv
{

	namespace math
	{

		using nv::sin;
		template < typename T, typename enable_if< is_fp_vec<T>::value >::type* = nullptr >
		inline T sin( const T& v )
		{
			return detail::unary_functor<T>::call( nv::sin, v );
		}

		using nv::cos;
		template < typename T, typename enable_if< is_fp_vec<T>::value >::type* = nullptr >
		inline T cos( const T& v )
		{
			return detail::unary_functor<T>::call( nv::cos, v );
		}

		using nv::tan;
		template < typename T, typename enable_if< is_fp_vec<T>::value >::type* = nullptr >
		inline T tan( const T& v )
		{
			return detail::unary_functor<T>::call( nv::tan, v );
		}

		using nv::asin;
		template < typename T, typename enable_if< is_fp_vec<T>::value >::type* = nullptr >
		inline T asin( const T& v )
		{
			return detail::unary_functor<T>::call( nv::asin, v );
		}

		using nv::acos;
		template < typename T, typename enable_if< is_fp_vec<T>::value >::type* = nullptr >
		inline T acos( const T& v )
		{
			return detail::unary_functor<T>::call( nv::acos, v );
		}

		using nv::atan;
		template < typename T, typename enable_if< is_fp_vec<T>::value >::type* = nullptr >
		inline T atan( const T& v )
		{
			return detail::unary_functor<T>::call( nv::atan, v );
		}

		using nv::atan2;
		template < typename T, typename enable_if< is_fp_vec<T>::value >::type* = nullptr >
		inline T atan2( const T& a, const T& b )
		{
			return detail::binary_functor<T>::call( nv::atan2, a, b );
		}

		using nv::sinh;
		template < typename T, typename enable_if< is_fp_vec<T>::value >::type* = nullptr >
		inline T sinh( const T& v )
		{
			return detail::unary_functor<T>::call( nv::sinh, v );
		}

		using nv::cosh;
		template < typename T, typename enable_if< is_fp_vec<T>::value >::type* = nullptr >
		inline T cosh( const T& v )
		{
			return detail::unary_functor<T>::call( nv::cosh, v );
		}

		using nv::tanh;
		template < typename T, typename enable_if< is_fp_vec<T>::value >::type* = nullptr >
		inline T tanh( const T& v )
		{
			return detail::unary_functor<T>::call( nv::tanh, v );
		}

		using nv::asinh;
		template < typename T, typename enable_if< is_fp_vec<T>::value >::type* = nullptr >
		inline T asinh( const T& v )
		{
			return detail::unary_functor<T>::call( nv::asinh, v );
		}

		using nv::acosh;
		template < typename T, typename enable_if< is_fp_vec<T>::value >::type* = nullptr >
		inline T acosh( const T& v )
		{
			return detail::unary_functor<T>::call( nv::acosh, v );
		}

		using nv::atanh;
		template < typename T, typename enable_if< is_fp_vec<T>::value >::type* = nullptr >
		inline T atanh( const T& v )
		{
			return detail::unary_functor<T>::call( nv::atanh, v );
		}
	}

}


#endif // NV_STL_MATH_TRIGONOMETRIC_HH
