// Copyright (C) 2016-2016 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
* @file lua_gfx.hh
* @author Kornel Kisielewicz epyon@chaosforge.org
*/

#ifndef NV_LUA_GFX_HH
#define NV_LUA_GFX_HH

#include <nv/common.hh>
#include <nv/interface/device.hh>
#include <nv/interface/context.hh>
#include <nv/lua/lua_state.hh>
#include <nv/lua/lua_math.hh>

namespace nv
{
	namespace lua
	{
		void register_gfx( lua_State* L );

		template<>
		struct pass_traits< color_mask > : metatable_pass_traits< color_mask >
		{
			static const char* metatable() { return "color_mask"; }
		};

		template<>
		struct pass_traits< scissor_test > : metatable_pass_traits< scissor_test >
		{
			static const char* metatable() { return "scissor_test"; }
		};

		template<>
		struct pass_traits< clear_state > : metatable_pass_traits< clear_state >
		{
			static const char* metatable() { return "clear_state"; }
		};

		namespace detail
		{
			inline bool is_color_mask( lua_State* L, int index ) { return is_userdata( L, index, pass_traits<color_mask>::metatable() ); }
			inline color_mask to_color_mask( lua_State* L, int index ) { return pass_traits<color_mask>::to( L, index ); }
			inline color_mask* to_pcolor_mask( lua_State* L, int index ) { return to_userdata<color_mask>( L, index ); }
			inline void push_color_mask( lua_State* L, const color_mask& v ) { pass_traits<color_mask>::push( L, v ); }

			inline bool is_scissor_test( lua_State* L, int index ) { return is_userdata( L, index, pass_traits<scissor_test>::metatable() ); }
			inline scissor_test to_scissor_test( lua_State* L, int index ) { return pass_traits<scissor_test>::to( L, index ); }
			inline scissor_test* to_pscissor_test( lua_State* L, int index ) { return to_userdata<scissor_test>( L, index ); }
			inline void push_scissor_test( lua_State* L, const scissor_test& v ) { pass_traits<scissor_test>::push( L, v ); }

			inline bool is_clear_state( lua_State* L, int index ) { return is_userdata( L, index, pass_traits<clear_state>::metatable() ); }
			inline clear_state to_clear_state( lua_State* L, int index ) { return pass_traits<clear_state>::to( L, index ); }
			inline clear_state* to_pclear_state( lua_State* L, int index ) { return to_userdata<clear_state>( L, index ); }
			inline void push_clear_state( lua_State* L, const clear_state& v ) { pass_traits<clear_state>::push( L, v ); }
		}


	}
}

#endif // NV_LUA_MAP_TILE_HH
