// Copyright (C) 2015-2016 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file image_writer.hh
 * @author Kornel Kisielewicz
 * @brief image_writer
 */

#ifndef NV_INTERFACE_IMAGE_WRITER_HH
#define NV_INTERFACE_IMAGE_WRITER_HH

#include <nv/common.hh>
#include <nv/stl/stream.hh>
#include <nv/interface/image_data.hh>

namespace nv
{

	class image_writer
	{
	public:
		virtual bool save( stream&, image_data* data ) = 0;
		virtual ~image_writer() {}
	};

}

#endif // NV_INTERFACE_IMAGE_WRITER_HH
