// Copyright (C) 2015-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
* @file image_loader.hh
* @author Kornel Kisielewicz
* @brief image_loader
*/

#ifndef NV_INTERFACE_IMAGE_LOADER_HH
#define NV_INTERFACE_IMAGE_LOADER_HH

#include <nv/common.hh>
#include <nv/stl/stream.hh>
#include <nv/interface/image_data.hh>

namespace nv
{

	class image_loader
	{
	public:
		virtual bool get_info( stream&, pixel_format& format, ivec2& size ) = 0;
		virtual bool test( stream& ) = 0;
		virtual image_data* load( stream& ) = 0;
		virtual image_data* load( stream&, pixel_format format ) = 0;
		virtual ~image_loader() {}
	};

}

#endif // NV_INTERFACE_IMAGE_LOADER_HH
