// Copyright (C) 2016-2016 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.
/**
* @file curses_terminal.hh
* @author Kornel Kisielewicz epyon@chaosforge.org
* @brief curses terminal interface
*/

#ifndef NV_GFX_TERMINAL_HH
#define NV_GFX_TERMINAL_HH

#include <nv/common.hh>
#include <nv/interface/terminal.hh>
#include <nv/interface/context.hh>

namespace nv
{
	struct gfx_terminal_data;


	struct gfx_terminal_draw_call
	{
		vertex_array va;
		uint32       va_count;
		texture      image;
		program      p;
	};

	class gfx_terminal : public terminal
	{
	public:
		/**
		* Constructor
		*/
		gfx_terminal( context* ctx, texture t, dimension tsize, dimension psize );

		/**
		* Update the screen
		*/
		virtual void update();

		/**
		* Print a character of the given color to the screen memory
		*/
		virtual void print( position p, term_color fgcolor, term_color bgcolor, char ch );

		/**
		* Clear screen memory
		*/
		virtual void clear( rectangle r, term_color fgcolor, term_color bgcolor );

		/**
		* Clear screen memory
		*/
		virtual void clear();

		/**
		* Polls event
		*/
		virtual bool poll( io_event& kevent );

		/**
		* Set cursor position
		*/
		virtual void set_cursor( position p );

		/**
		* Show cursor
		*/
		virtual void show_cursor();

		/**
		* Hide cursor
		*/
		virtual void hide_cursor();

		/**
		* Virtual destructor
		*/
		virtual ~gfx_terminal();

		gfx_terminal_draw_call& temp_dc()
		{
			return m_dc;
		}

	protected:
		context*               m_context;
		gfx_terminal_draw_call m_dc;
		gfx_terminal_data*     m_data;
		bool                   m_update_needed;
	};
}

#endif // NV_GFX_TERMINAL_HH
