// Copyright (C) 2016-2016 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file program_manager.hh
 * @author Kornel Kisielewicz
 * @brief program manager
 */

#ifndef NV_ENGINE_PARTICLE_MANAGER_HH
#define NV_ENGINE_PARTICLE_MANAGER_HH

#include <nv/common.hh>
#include <nv/engine/resource_system.hh>
#include <nv/engine/particle_engine.hh>

namespace nv
{

	class particle_manager : public lua_resource_manager< particle_system_data >
	{
	public:
		explicit particle_manager() {}
		virtual string_view get_storage_name() const { return "psystems"; }
		virtual string_view get_resource_name() const { return "psystem"; }
		virtual void initialize( lua::state* state );
	protected:
		virtual bool load_resource( lua::table_guard& table, shash64 id );
	};
}

#endif // NV_ENGINE_PARTICLE_MANAGER_HH
