// Copyright (C) 2016-2017 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#ifndef NV_ENGINE_DECAL_GROUP
#define NV_ENGINE_DECAL_GROUP

#include <nv/common.hh>
#include <nv/stl/math.hh>
#include <nv/stl/vector.hh>
#include <nv/stl/handle.hh>
#include <nv/interface/context.hh>
#include <nv/stl/handle_store.hh>

namespace nv
{

	struct decal_data
	{
		mat4 model;
		vec3 center;
	};

	struct decal_block_data
	{
		mat4 model;
		vec2 tca;
		vec2 tcb;
	};

	struct decal_group_info
	{
		uint32                count;
		uint32                quota;
		vertex_array          vtx_array;
		buffer                vtx_buffer;
		bool                  local;
		decal_data*        quads;
		uint32                ref_counter;
	};

	struct decal_group_tag {};
	typedef handle< uint32, 16, 16, decal_group_tag > decal_group;

	class decal_group_manager
	{
	public:
		decal_group_manager( context* a_context );
		decal_group create_group( uint32 max_particles );
		void release( decal_group group );

		bool ref( decal_group group );
		bool unref( decal_group group );
		void clear();
	protected:
		void release( decal_group_info* info );

		context* m_context;
		handle_store< decal_group_info, decal_group > m_groups;

	};

}

#endif // NV_ENGINE_DECAL_GROUP
