// Copyright (C) 2016-2017 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
* @file field_detection.hh
* @author Kornel Kisielewicz epyon@chaosforge.org
* @brief Compile time field detection for nv ecs
*/

#ifndef NV_ECS_FIELD_DETECTION_HH
#define NV_ECS_FIELD_DETECTION_HH

namespace nv
{
	namespace lua
	{
		class stack_proxy;
	}

	namespace ecs
	{

		namespace detail
		{
			template<typename, typename T>
			struct has_message
			{
				static_assert( nv::integral_constant<T, false>::value, "Second template parameter needs to be of function type." );
			};

			template< typename C, typename Ret, typename... Args >
			struct has_message<C, Ret( Args... )>
			{
			private:
				template<typename T>
				static constexpr auto check( T* )
					-> typename nv::is_same< decltype( nv::declval<T>().on( nv::declval<Args>()... ) ), Ret >::type;

				template<typename>
				static constexpr nv::false_type check( ... );

			public:
				typedef decltype( check<C>( 0 ) ) type;

				static constexpr bool value = type::value;
			};

			template< typename, typename T >
			struct has_update
			{
				static_assert( nv::integral_constant<T, false>::value, "Second template parameter needs to be of function type." );
			};

			template< typename C, typename Ret, typename... Args >
			struct has_update<C, Ret( Args... )>
			{
			private:
				template<typename T>
				static constexpr auto check( T* )
					-> typename nv::is_same< decltype( nv::declval<T>().update( nv::declval<Args>()... ) ), Ret >::type;

				template<typename>
				static constexpr nv::false_type check( ... );
			public:
				typedef decltype( check<C>( 0 ) ) type;
				static constexpr bool value = type::value;
			};

			template<typename, typename T>
			struct has_destroy
			{
				static_assert( nv::integral_constant<T, false>::value, "Second template parameter needs to be of function type." );
			};

			template< typename C, typename Ret, typename... Args >
			struct has_destroy<C, Ret( Args... )>
			{
			private:
				template<typename T>
				static constexpr auto check( T* )
					-> typename nv::is_same< decltype( nv::declval<T>().destroy( nv::declval<Args>()... ) ), Ret >::type;

				template<typename>
				static constexpr nv::false_type check( ... );
			public:
				typedef decltype( check<C>( 0 ) ) type;
				static constexpr bool value = type::value;
			};

			template<typename, typename T>
			struct has_create
			{
				static_assert( nv::integral_constant<T, false>::value, "Second template parameter needs to be of function type." );
			};

			template< typename C, typename Ret, typename... Args >
			struct has_create<C, Ret( Args... )>
			{
			private:
				template<typename T>
				static constexpr auto check( T* )
					-> typename nv::is_same< decltype( nv::declval<T>().create( nv::declval<Args>()... ) ), Ret >::type;

				template<typename>
				static constexpr nv::false_type check( ... );
			public:
				typedef decltype( check<C>( 0 ) ) type;
				static constexpr bool value = type::value;
			};

			template < typename S, typename T, typename Cs >
			struct has_ct_update_helper;

			template < typename S, typename T, typename... Cs >
			struct has_ct_update_helper< S, T, mpl::list< Cs... > >
			{
				using type = detail::has_update<S, void( Cs&..., T ) >;
			};

			template < typename S, typename E, typename T, typename Cs >
			struct has_ect_update_helper;

			template < typename S, typename E, typename T, typename... Cs >
			struct has_ect_update_helper< S, E, T, mpl::list< Cs... > >
			{
				using type = detail::has_update<S, void( E&, Cs&..., T ) >;
			};

			template < typename S, typename E, typename M, typename Cs >
			struct has_ec_message_helper;

			template < typename S, typename E, typename M, typename... Cs >
			struct has_ec_message_helper< S, E, M, mpl::list< Cs... > >
			{
				using type = detail::has_message<S, void( const M&, E&, Cs&... ) >;
			};

			template < typename S, typename M, typename Cs >
			struct has_c_message_helper;

			template < typename S, typename M, typename... Cs >
			struct has_c_message_helper< S, M, mpl::list< Cs... > >
			{
				using type = detail::has_message<S, void( const M&, Cs&... ) >;
			};

		}

		template < typename S, typename M >
		using has_message = detail::has_message<S, void( const M& ) >;

		template < typename C >
		struct has_components
		{
		private:
			template < typename T >
			static true_type  test( typename T::components* );
			template < typename >
			static false_type test( ... );
		public:
			typedef decltype( test<C>( 0 ) ) type;
			static constexpr bool value = type::value;
		};

		template < typename E, typename S, typename T >
		using has_ecs_update = detail::has_update<S, void( E&, T ) >;

		template < typename S, typename T >
		using has_destroy = detail::has_destroy<S, void( T& ) >;

		template < typename S, typename T, typename H >
		using has_create = detail::has_create<S, void( H, T&, const lua::stack_proxy& ) >;

		template < typename S, typename Cs, typename T >
		using has_component_update = typename detail::has_ct_update_helper<S, T, Cs >::type;

		template < typename E, typename S, typename Cs, typename T >
		using has_ecs_component_update = typename detail::has_ect_update_helper<S, E, T, Cs >::type;

		template < typename S, typename Cs, typename M >
		using has_component_message = typename detail::has_c_message_helper<S, M, Cs >::type;

		template < typename E, typename S, typename Cs, typename M >
		using has_ecs_component_message = typename detail::has_ec_message_helper<S, E, M, Cs >::type;

		template < typename E, typename S, typename M >
		using has_ecs_message = detail::has_message<S, void( const M&, E& ) >;

	}

}

#endif // NV_ECS_FIELD_DETECTION_HH
