// Copyright (C) 2016-2016 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file aabb.hh
 * @author Kornel Kisielewicz
 * @brief axis aligned bounding box utility class
 */

#ifndef NV_CORE_AABB_HH
#define NV_CORE_AABB_HH

#include <nv/common.hh>
#include <nv/stl/math.hh>
#include <nv/core/transform.hh>
#include <nv/stl/utility/common.hh>

namespace nv
{

	class aabb
	{
	public:
		aabb() = default;
		aabb( const transform& root, const vec3& hextents )
			: m_root( root ), m_hextents( hextents ) {}
		aabb( const aabb& ) = default;
		aabb( aabb&& ) = default;
		const vec3& get_hextents() { return m_hextents; }
		const transform& get_root() { return m_root; }
	protected:
		transform m_root;
		vec3      m_hextents;
	};

}

#endif // NV_CORE_AABB_HH
