// Copyright (C) 2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file assert.hh
 * @author Kornel Kisielewicz
 * @brief Assert functions
 */
// TODO: assert levels
// TODO: assert should not depend on CORE!

#ifndef NV_BASE_COMMON_HH
#error "Do not include assert.hh directly, inlcude nv/common.hh"
#endif

#ifndef NV_BASE_ASSERT_HH
#define NV_BASE_ASSERT_HH

#ifdef assert
#undef assert
#endif

namespace nv
{
	namespace detail
	{
		NV_NORETURN void abort( const char * msg, const char * file, unsigned int line, const char * function );
		NV_NORETURN void assert_abort( const char * msg, const char * file, unsigned int line, const char * function );
#if NV_DEBUG
#	if NV_COMPILER == NV_MSVC
		NV_NORETURN void assert_fail( const wchar_t * message, const wchar_t* file, unsigned line );
#	else
		NV_NORETURN void assert_fail( const char * assertion, const char * file, unsigned int line, const char * function );
#	endif
#endif
	}

	NV_NORETURN void exit( int ret_val );
}



#define NV_ABORT( msg ) ::nv::detail::abort( msg, __FILE__, __LINE__, NV_FUNC_SIG )

#if NV_DEBUG
#	if NV_COMPILER == NV_MSVC
#	define NV_ASSERT_COND(cond) (void)( (!!(cond)) || (::nv::detail::assert_fail(NV_WIDE(#cond), NV_WIDE(__FILE__), __LINE__), 0) )
#	else
#	define NV_ASSERT_COND(cond) ((cond) ? static_cast<void>(0) : ::nv::detail::assert_fail(NV_STRINGIZE(cond), __FILE__, __LINE__, __PRETTY_FUNCTION__))
#	endif
#define NV_ASSERT(cond, msg) NV_ASSERT_COND( (cond) && "assertion failed:" msg )
#define NV_ASSERT_DEBUG(cond, msg) NV_ASSERT_COND( (cond) && "assertion failed:" msg )
#define NV_ASSERT_ALWAYS(cond, msg) NV_ASSERT_COND( (cond) && "assertion failed:" msg )
#else  
#define NV_ASSERT(cond, msg) ((void)0)
#define NV_ASSERT_DEBUG(cond, msg) ((void)0)
#define NV_ASSERT_ALWAYS(cond, msg) ((cond) ? static_cast<void>(0) : ::nv::detail::assert_abort(NV_STRINGIZE(cond) " " msg, __FILE__, __LINE__, NV_FUNC_SIG ))
#endif 

#endif // NV_BASE_ASSERT_HH
