#version 120

uniform sampler2D nv_t_diffuse;
uniform sampler2D nv_t_specular;
uniform sampler2D nv_t_normal;
uniform vec4 light_diffuse;
uniform vec4 light_specular;
uniform mat4 nv_m_view_inv;

varying vec2 v_texcoord;
varying vec3 v_normal;
varying vec3 v_light_vector;
varying vec3 v_view_vector;
varying vec4 v_position;
varying mat3 v_m33_tangent;
 
void main(void) {
	vec2 texcoord         = v_texcoord;
	//
	vec4 encoded_normal   = texture2D( nv_t_normal, texcoord );
	encoded_normal.y      = 1 - encoded_normal.y;
	vec3 local_coords     = 2.0 * encoded_normal.rgb - vec3(1.0);
	vec3 normal_direction = normalize(v_m33_tangent * local_coords);
	vec3 view_direction   = normalize(vec3(nv_m_view_inv * vec4(0.0, 0.0, 0.0, 1.0) - v_position));
	vec3 nnormal         = normal_direction;
	//

//	vec3 nnormal         = normalize( v_normal );
	vec3 nlight_vector   = normalize( v_light_vector );
	vec3 nview_vector    = normalize( v_view_vector );
	vec3 nreflect_vector = reflect( -nlight_vector, nnormal );

	float specular_value = clamp( dot( nreflect_vector, nview_vector ), 0.0, 1.0 );
	specular_value       = pow( specular_value, 6.0 );
	float diffuse_value  = max( dot( nlight_vector, nnormal ), 0.0 );

	vec3 diff_texel      = vec3( texture2D( nv_t_diffuse, texcoord ) );	
	vec4 spec_texel      = texture2D( nv_t_specular, texcoord );
	
	float specular_amount = spec_texel.x;
	float diffuse_amount  = 1.0 - specular_amount;

	float final_specular = specular_amount * specular_value;
	float final_diffuse  = diffuse_amount  * diffuse_value;

	vec3 diffuse_color   = light_diffuse.xyz  * final_diffuse * diff_texel;
	vec3 specular_color  = light_specular.xyz * final_specular;

	gl_FragColor = vec4( diffuse_color + specular_color, 1.0 );
}