// Copyright (C) 2012-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file md3_loader.hh
 * @author Kornel Kisielewicz
 * @brief md3 loader
 */

#ifndef NV_FORMATS_MD3_LOADER_HH
#define NV_FORMATS_MD3_LOADER_HH

#include <nv/common.hh>
#include <nv/core/transform.hh>
#include <nv/interface/mesh_data.hh>
#include <nv/interface/mesh_loader.hh>

namespace nv 
{
	struct md3_key
	{
		transform tform;
	};


	class md3_loader : public mesh_loader
	{
	public:
		explicit md3_loader( string_table* strings, bool merge_all = true );
		virtual ~md3_loader();
		virtual bool load( stream& source );
		virtual data_channel_set* release_mesh_data( size_t index = 0 );
		virtual size_t get_mesh_count() const { return 1; }
		size_t get_max_frames() const;
		virtual size_t get_nodes_data_count() const { return 1; }
		virtual mesh_nodes_data* release_mesh_nodes_data( size_t = 0 );
	private:
		void release_mesh_frame( data_channel_set* data, sint32 frame, sint32 surface );
		void load_tags( raw_data_channel* channel, const string_view& tag );

		bool m_merge_all;
		void* m_md3;
	};

}

#endif // NV_FORMATS_MD3_LOADER_HH
