// Copyright (C) 2015-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
* @file material_manager.hh
* @author Kornel Kisielewicz
* @brief material_manager
*/

#ifndef NV_ENGINE_MATERIAL_MANAGER_HH
#define NV_ENGINE_MATERIAL_MANAGER_HH

#include <nv/common.hh>
#include <nv/core/resource.hh>
#include <nv/interface/device.hh>
#include <nv/interface/mesh_data.hh>
#include <nv/gfx/skeleton_instance.hh>
#include <nv/engine/resource_system.hh>
#include <nv/engine/image_manager.hh>

namespace nv
{

	struct material
	{
		string128 id;
		string128 paths[ 8 ];
	};

	struct gpu_material
	{
		texture textures[ 8 ];
	};

	NV_RTTI_DECLARE_NAME( gpu_material, "gpu_material" )
	NV_RTTI_DECLARE_NAME( material, "material" )

	class material_manager : public lua_resource_manager< material >
	{
	public:
		virtual string_view get_storage_name() const { return "materials"; }
		virtual string_view get_resource_name() const { return "material"; }
		explicit material_manager( bool clear_paths ) : m_clear_paths( clear_paths ) {}
	protected:
		virtual bool load_resource( lua::table_guard& table, shash64 id );
	private:
		bool m_clear_paths;
	};

	class gpu_material_manager : public dependant_resource_manager< gpu_material, material_manager >
	{
	public:
		gpu_material_manager( context* context, material_manager* matmgr, image_manager* imgmgr );
	protected:
		resource< gpu_material > create_resource( resource< material > m );
		virtual void release( gpu_material* m );
	private:
		texture           m_default;
		context*          m_context;
		image_manager*    m_image_manager;
	};

}

#endif // NV_ENGINE_MATERIAL_MANAGER_HH
