// Copyright (C) 2015-2017 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#ifndef NV_IMAGE_MINIZ_HH
#define NV_IMAGE_MINIZ_HH

#include <nv/common.hh>
#include <nv/interface/image_loader.hh>
#include <nv/interface/image_data.hh>
#include <nv/stl/stream.hh>

namespace nv
{

	void *miniz_decompress( const void *source_buf, size_t source_buf_len, size_t *out_len, bool parse_header );
	int miniz_compress( unsigned char *pDest, unsigned long *pDest_len, const unsigned char *pSource, unsigned long source_len, int level );
	unsigned long miniz_bound( unsigned long source_len );

}

#endif // NV_IMAGE_MINIZ_HH
