// Copyright (C) 2017-2017 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#ifndef NV_LUA_ITERATOR_HH
#define NV_LUA_ITERATOR_HH

#include <nv/common.hh>
#include <nv/stl/string.hh>
#include <nv/stl/iterator.hh>
#include <nv/lua/lua_proxy.hh>

namespace nv
{

	namespace lua
	{
		class state;
		class lua_iterator_provider;

		class iterator_base 
		{
		public:
			explicit iterator_base( state* state = nullptr, sint32 index = -1 );

			iterator_base& operator++ ()
			{
				next();
				return *this;
			}

			bool operator!= ( const iterator_base& ) const
			{
				return m_state != nullptr;
			}
		protected:
			void next();

			state* m_state;
			sint32 m_index;
		};

		class kv_iterator : public iterator_base
		{
		public:
			using iterator_base::iterator_base;
			kv_proxy operator* () const { return kv_proxy( m_state ); }
		};

		class key_iterator : public iterator_base
		{
		public:
			using iterator_base::iterator_base;
			stack_proxy operator* () const { return stack_proxy( m_state, -2 ); }
		};

		class value_iterator : public iterator_base
		{
		public:
			using iterator_base::iterator_base;
			stack_proxy operator* () const { return stack_proxy( m_state, -1 ); }
		};

		class iterator_provider_base
		{
		public:
			iterator_provider_base( state* parent, int index );
			iterator_provider_base( const iterator_provider_base& ) = delete;
			iterator_provider_base& operator=( const iterator_provider_base& ) = delete;
			iterator_provider_base( iterator_provider_base&& other )
			{
				m_parent = other.m_parent;
				m_index = other.m_index;
				m_level = other.m_level;
				other.m_parent = nullptr;
			}
			iterator_provider_base& operator=( iterator_provider_base&& other )
			{
				if ( this != &other )
				{
					m_parent = other.m_parent;
					m_index = other.m_index;
					m_level = other.m_level;
					other.m_parent = nullptr;
				}
				return *this;
			}
			~iterator_provider_base();
		protected:
			friend class iterator_base;

			state* m_parent;
			int m_level;
			int m_index;
		};


		template < typename Iterator >
		class iterator_provider : public iterator_provider_base
		{
		public:
			using iterator_provider_base::iterator_provider_base;

			Iterator begin() { return Iterator( m_parent, m_index ); }
			Iterator end() { return Iterator(); }
		};


	};

}

#endif // NV_LUA_PROXY_HH
