// Copyright (C) 2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.
//
// TODO: speedup conversion by doing divisions by 100

#include "nv/stl/string.hh"

#include <cstdio>
#include <cstdlib>

using namespace nv;

//static const double s_power_10[] = { 1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000 };

static inline void string_reverse( char* begin, char* end )
{
	char temp;
	while ( end > begin )
	{
		temp = *end;
		*end-- = *begin;
		*begin++ = temp;
	}
}

nv::uint32 nv::sint32_to_buffer( array_ref< char > buffer, sint32 n )
{
	if ( buffer.size() < 2 ) return 0;
	char* last = buffer.end() - 1;
	char* s = buffer.begin();
	uint32 abs = static_cast<uint32>( n < 0 ? -n : n );
	do
	{
		if ( s == last ) { *buffer.begin() = '\0'; return 0;  }
		*s++ = static_cast<char>( '0' + ( abs % 10 ) );
		abs /= 10;
	} while ( abs > 0 );
	if ( n < 0 )
	{
		if ( s == last ) { *buffer.begin() = '\0'; return 0; }
		*s++ = '-';
	}
	*s = '\0';
	string_reverse( buffer.begin(), s - 1 );
	return static_cast<nv::uint32>( s - buffer.begin() );
}

nv::uint32 nv::sint64_to_buffer( array_ref< char > buffer, sint64 n )
{
	if ( buffer.size() < 2 ) return 0;
	char* last = buffer.end() - 1;
	char* s = buffer.begin();
	uint64 abs = static_cast<uint64>( n < 0 ? -n : n );
	do
	{
		if ( s == last ) { *buffer.begin() = '\0'; return 0; }
		*s++ = static_cast<char>( '0' + ( abs % 10 ) );
		abs /= 10;
	} while ( abs > 0 );
	if ( n < 0 )
	{
		if ( s == last ) { *buffer.begin() = '\0'; return 0; }
		*s++ = '-';
	}
	*s = '\0';
	string_reverse( buffer.begin(), s - 1 );
	return static_cast<nv::uint32>( s - buffer.begin() );
}

nv::uint32 nv::uint32_to_buffer( array_ref< char > buffer, uint32 n )
{
	if ( buffer.size() < 2 ) return 0;
	char* last = buffer.end() - 1;
	char* s = buffer.begin();
	do
	{
		if ( s == last ) { *buffer.begin() = '\0'; return 0; }
		*s++ = static_cast<char>( '0' + ( n % 10 ) );
		n /= 10;
	} while ( n > 0 );
	*s = '\0';
	string_reverse( buffer.begin(), s - 1 );
	return static_cast<nv::uint32>( s - buffer.begin() );
}

nv::uint32 nv::uint64_to_buffer( array_ref< char > buffer, uint64 n )
{
	if ( buffer.size() < 2 ) return 0;
	char* last = buffer.end() - 1;
	char* s = buffer.begin();
	do
	{
		if ( s == last ) { *buffer.begin() = '\0'; return 0; }
		*s++ = static_cast<char>( '0' + ( n % 10 ) );
		n /= 10;
	} while ( n > 0 );
	*s = '\0';
	string_reverse( buffer.begin(), s - 1 );
	return static_cast<nv::uint32>( s - buffer.begin() );
}

nv::uint32 nv::f32_to_buffer( array_ref< char > buffer, f32 n )
{
#if NV_COMPILER == NV_MSVC
	int result = sprintf_s( buffer.data(), buffer.size(), "%.*g", 6, n );
#else
	int result = snprintf( buffer.data(), buffer.size(), "%.*g", 6, n );
#endif
	return static_cast<nv::uint32>( result > 0 ? result : 0 );
}

nv::uint32 nv::f64_to_buffer( array_ref< char > buffer, f64 n )
{
#if NV_COMPILER == NV_MSVC
	int result = sprintf_s( buffer.data(), buffer.size(), "%.*g", 6, n );
#else
	int result = snprintf( buffer.data(), buffer.size(), "%.*g", 6, n );
#endif
	return static_cast<nv::uint32>( result > 0 ? result : 0 );
}

sint32 nv::buffer_to_sint32( const char* str, char** end )
{
	const char* s = str;
	while ( *s == ' ' ) ++s;
	sint32 result = 0;
	bool positive = true;
	switch ( *s )
	{
	case '-': ++s; positive = false; break;
	case '+': ++s; break;
	default: break;
	}
	while ( *s >= '0' && *s <= '9' )
	{
		result = ( result * 10 ) + ( *s - '0' );
		++s;
	}
	if ( end != nullptr ) *end = const_cast<char*>( s );
	return positive ? result : -result;
}

sint64 nv::buffer_to_sint64( const char* s, char** end )
{
	while ( *s == ' ' ) ++s;
	sint64 result = 0;
	bool positive = true;
	switch ( *s )
	{
	case '-': ++s; positive = false; break;
	case '+': ++s; break;
	default: break;
	}
	while ( *s >= '0' && *s <= '9' )
	{
		result = ( result * 10 ) + ( *s - '0' );
		++s;
	}
	if ( end != nullptr ) *end = const_cast<char*>( s );
	return positive ? result : -result;
}

uint32 nv::buffer_to_uint32( const char* s, char** end )
{
	while ( *s == ' ' ) ++s;
	uint32 result = 0;
	while ( *s >= '0' && *s <= '9' )
	{
		result = ( result * 10 ) + static_cast<uint32>( *s - '0' );
		++s;
	}
	if ( end != nullptr ) *end = const_cast<char*>( s );
	return result;
}

uint64 nv::buffer_to_uint64( const char* s, char** end )
{
	while ( *s == ' ' ) ++s;
	uint64 result = 0;
	while ( *s >= '0' && *s <= '9' )
	{
		result = ( result * 10 ) + static_cast<uint32>( *s - '0' );
		++s;
	}
	if ( end != nullptr ) *end = const_cast<char*>( s );
	return result;
}

float nv::buffer_to_f32( const char* s, char** end )
{
	return strtof( s, end );
}

double nv::buffer_to_f64( const char* s, char** end )
{
	return strtod( s, end );
}
