// Copyright (C) 2016-2017 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#include "nv/lua/lua_types.hh"

#include "nv/lua/lua_raw.hh"

using namespace nv;

bool nv::lua::read_rtti_type( lua::state* state, const type_entry* entry, void* object, int index )
{
	const lua::type_data* td = state->get_type_data();
	const type_database*  db = td->get_type_database();
	NV_ASSERT_ALWAYS( db == entry->type_db, "Type database mismatch between Lua and entry!" );

	const lua::lua_rtti_read_function* read = td->get_read( entry->hash );
	if ( read )
	{
		return (*read)( state, entry, object, index );
	}

	lua_State* lstate = state->get_raw();
	int ltype = lua_type( lstate, index );
	index = nlua_absindex( lstate, index );
	int fcount = int( entry->field_list.size() );

	if ( fcount > 0 && ltype == LUA_TTABLE )
	{
		// numerical assignment
		if ( lua_objlen( lstate, index ) > 0 )
		{
			int i = 0;
			for (;;)
			{
				i++;
				lua_rawgeti( lstate, index, i );
				if ( lua_isnil( lstate, -1 ) || i > fcount )
				{
					lua_pop( lstate, 1 );
					break;
				}
				const type_field& f = entry->field_list[i - 1];
				read_rtti_type( state, f.type, (char*)object + f.offset, -1 );
				lua_pop( lstate, 1 );
			};

		}

		// by name assignment
		lua_pushnil( lstate );
		while ( lua_next( lstate, index ) != 0 )
		{
			if ( lua_type( lstate, -2 ) == LUA_TSTRING )
			{
				string_view key = nlua_tostringview( lstate, -2 );
				auto fit = entry->field_names.find(key);
				if ( fit != entry->field_names.end() )
				{
					const type_field& f = entry->field_list[ fit->second ];
					read_rtti_type( state, f.type, (char*)object + f.offset, -1 );
				}
			}
			lua_pop( lstate, 1 );
		}
		return true;
	}
	int ecount = int( entry->enum_list.size() );
	if ( ecount > 0 )
	{
		if ( ltype == LUA_TSTRING )
		{
			string_view key = nlua_tostringview( lstate, index );
			auto eit = entry->enum_names.find( key );
			if ( eit != entry->enum_names.end() )
			{
				int error; // proper type instead of sint32?
				*(sint32*)object = entry->enum_list[eit->second].value;
				return true;
			}
		}
		if ( ltype == LUA_TNUMBER )
		{
			int error; // proper type instead of sint32?
			*(sint32*)object = (sint32)lua_tointeger( lstate, index );
			return true;
		}
	}
	return false;
}

static void nlua_rtti_proxy_push_field( lua_State * L, void* object, type_field& f )
{
	//throw std::logic_error( "The method or operation is not implemented." );
}

static void nlua_rtti_proxy_set_field( lua_State * L, void* object, type_field& f, int index )
{
	//throw std::logic_error( "The method or operation is not implemented." );
}

static int nlua_rtti_proxy_index( lua_State * L )
{
	type_entry* entry  = reinterpret_cast<type_entry*>( lua_touserdata( L, lua_upvalueindex( 1 ) ) );
	void*       object = lua_touserdata( L, lua_upvalueindex( 2 ) );
	nv::string_view index = nlua_tostringview( L, 2 );
	auto f = entry->field_names.find( index );
	if ( f != entry->field_names.end() )
	{
		nlua_rtti_proxy_push_field( L, object, entry->field_list[ f->second ] );
	}
	else
	{
		int error;
		lua_pushnil( L );
	}
	return 1;
}

static int nlua_rtti_proxy_newindex( lua_State * L )
{
	type_entry* entry = reinterpret_cast<type_entry*>( lua_touserdata( L, lua_upvalueindex( 1 ) ) );
	void*       object = lua_touserdata( L, lua_upvalueindex( 2 ) );
	nv::string_view index = nlua_tostringview( L, 2 );
	auto f = entry->field_names.find( index );
	if ( f != entry->field_names.end() )
	{
		nlua_rtti_proxy_set_field( L, object, entry->field_list[f->second], 3 );
	}
	else
	{
		int error;
	}
	return 1;
}

/*

static void nlua_push_function( lua_State* L, const type_entry* entry, lua_CFunction f )
{
	lua_pushlightuserdata( L, const_cast<type_entry*>( entry ) );
	lua_pushcclosure( L, f, 1 );
}

static void nlua_rtti_requiref( lua_State *L, const type_entry* entry, const char *modname, lua_CFunction openf, int glb )
{
	int only_works_for_51;
	nlua_push_function( L, entry, openf );
	lua_pushstring( L, modname );
	lua_call( L, 1, 1 );
	if ( glb != 0 )
	{
		lua_pushvalue( L, LUA_GLOBALSINDEX );
		lua_pushvalue( L, -2 );
		lua_setfield( L, -2, modname );
		lua_pop( L, 1 );
	}
}

static void nlua_rtti_register( lua_State *L, const type_entry* entry, const luaL_Reg *l )
{
	int index = nlua_absindex( L, -1 );
	for ( ; l->name != NULL; l++ )
	{
		lua_pushstring( L, l->name );
		nlua_push_function( L, entry, l->func );
		lua_rawset( L, index );
	}
}

static int nlua_rtti_open( lua_State *L )
{
// 	type_entry* entry = reinterpret_cast<type_entry*>( lua_touserdata( L, lua_upvalueindex( 1 ) ) );
// 
// 	luaL_newmetatable( L, entry->type_db->resolve_name( entry ).data() );
// 	nlua_register( L, nlua_vec_m, -1 );
// 	lua_createtable( L, 0, 0 );
// 	nlua_register( L, nlua_vec_f, -1 );
// 	lua_setfield( L, -2, "__functions" );
// 	lua_pop( L, 1 );
// 
// 	lua_createtable( L, 0, 0 );
// 	nlua_register( L, nlua_vec_sf, -1 );
// 	lua_createtable( L, 0, 0 );
// 	nlua_register( L, nlua_vec_sm, -1 );
// 	lua_setmetatable( L, -2 );
	return 1;
}

void nv::lua::register_lua_rtti_type( const string_view& name, lua::state* state, const type_entry* entry )
{
	const type_database* db = state->get_type_db();
	NV_ASSERT_ALWAYS( db == entry->type_db, "Type database mismatch between Lua and entry!" );
	lua_pushlightuserdata( state->get_raw(), const_cast< type_entry* >( entry ) );
	int lua_ref


	
}
*/
