local NV_BT_SFX = ""
if NV_RUNTIME == "dcrt" then
	NV_BT_SFX = "_dcrt"
end

function nv_bullet_configure( dir, subdir, suffix )
	suffix = suffix or ""
	links 
	{
		"BulletCollision"..suffix..NV_BT_SFX,
		"BulletDynamics"..suffix..NV_BT_SFX,
		"BulletSoftBody"..suffix..NV_BT_SFX,
		"LinearMath"..suffix..NV_BT_SFX,
	}
	libdirs { dir.."lib/"..subdir.."/" }
	includedirs { dir.."src/" }
end

project "nv-bullet"
	location (_ACTION.."/"..NV_RUNTIME)
	language "C++"
	kind "StaticLib"
	files { "nv/bullet/**.hh", "src/bullet/**.cc" }
	includedirs { 
		"../nv"
	}
	links { "nv-core", "nv-gl", "nv-formats", "nv-lua", "nv-lib", "nv-io", "nv-gfx" }

	includedirs { "D:/Libraries/bullet2/src/" }

	configuration "debug"
		nv_bullet_configure( "D:/Libraries/bullet2/x86/", "RelWithDebInfo", "_rdbg" )
--		nv_bullet_configure( "D:/Libraries/bullet2/x86/", "Debug", "_debug" )

	configuration "profiler"
		nv_bullet_configure( "D:/Libraries/bullet2/x86/", "Release" )

	configuration "release"
		nv_bullet_configure( "D:/Libraries/bullet2/x86/", "Release" )

	configuration "debug_64"
		nv_bullet_configure( "D:/Libraries/bullet2/x86_64/", "RelWithDebInfo", "_rdbg" )
--		nv_bullet_configure( "D:/Libraries/bullet2/x86_64/", "Debug", "_debug" )

	configuration "profiler_64"
		nv_bullet_configure( "D:/Libraries/bullet2/x86_64/", "Release" )

	configuration "release_64"
		nv_bullet_configure( "D:/Libraries/bullet2/x86_64/", "Release" )



