// Copyright (C) 2014-2015 ChaosForge Ltd 
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#ifndef NV_WX_CANVAS_HH
#define NV_WX_CANVAS_HH

#include <nv/wx/wx.hh>
#include <nv/common.hh>
#include <nv/core/logger.hh>
#include <nv/lib/gl.hh>
#include <nv/gl/gl_device.hh>
#include <nv/gl/gl_window.hh>
#include <nv/sdl/sdl_input.hh>
#include <nv/sdl/sdl_window_manager.hh>
#include <nv/interface/context.hh>
#include <nv/interface/window.hh>

#define NV_WX_APP_FRAME( frame ) IMPLEMENT_APP( nv::wx_app< frame > ) 

namespace nv
{

	class wx_app_base : public wxApp
	{
	public:
		wx_app_base();
		virtual bool OnInit();
		virtual int OnExit();
		virtual bool initialize() = 0;
	protected:
		nv::logger m_logger;
	};

	template< class MainFrame >
	class wx_app : public wx_app_base
	{
	public:
		wx_app() : wx_app_base() {}
		virtual bool initialize()
		{
			new MainFrame();
			return true;
		}
	};

	class wx_gl_canvas : public wxWindow
	{
	public:
		explicit wx_gl_canvas( wxWindow *parent, input* in );
		explicit wx_gl_canvas( wxWindow *parent, wx_gl_canvas *sibling, input* in );
		virtual void on_update() = 0;
		virtual void stop();
		virtual void start();
		virtual void on_idle( wxIdleEvent& evt );
		virtual void make_current();
		uint32 window_id() { return m_window->window_id(); }
		~wx_gl_canvas();
	protected:
		virtual void on_paint( wxPaintEvent& event );

		nv::window_manager* m_wm;
		nv::device*         m_device;
		nv::context*        m_context;
		nv::window*         m_window;
		bool                m_render;
		bool                m_main;
		wxDECLARE_EVENT_TABLE();
	};

	class wx_gl_canvas_lock
	{
	public:
		wx_gl_canvas_lock( wx_gl_canvas* canvas ) : m_canvas( canvas ) { m_canvas->stop(); }
		~wx_gl_canvas_lock() { m_canvas->start(); }
	private:
		wx_gl_canvas* m_canvas;
	};

	class wx_gl_update_timer : public wxTimer
	{
	public:
		explicit wx_gl_update_timer( wx_gl_canvas* canvas )
			: wxTimer(), m_canvas( canvas ) {}
		virtual void Notify() { m_canvas->on_update(); }
	private:
		wx_gl_canvas* m_canvas;
	};

	class wx_log_text_ctrl_sink : public nv::log_sink
	{
	public:
		wx_log_text_ctrl_sink( wxTextCtrl* a_text_ctrl );
		virtual void log( nv::log_level level, const nv::string_view& message );
	private:
		wxTextCtrl* m_text_ctrl;
	};

}

#endif NV_WX_CANVAS_HH
