// Copyright (C) 2012-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#ifndef NV_STL_STRING_CONST_STRING_HH
#define NV_STL_STRING_CONST_STRING_HH

#include <nv/stl/string/common.hh>
#include <nv/stl/string/string_base.hh>

namespace nv
{

	// const string is movable but not copyable
	class const_string : public string_base< array_view< char > >
	{
	public:
		inline const_string() {}
		inline const_string( const char* str, size_type len )
		{
			initialize( str, len );
		}
		inline explicit const_string( const char* str )
		{
			initialize( str, static_cast< uint32 >( nvstrlen( str ) ) );
		}
		inline const_string( const string_view& rhs ) 
		{
			initialize( rhs.data(), rhs.size() );
		}
		template< size_t N >
		inline const_string( char( &s )[N] )
		{
			initialize( s, static_cast< uint32 >( N-1 ) );
		}
		template< size_t N >
		inline const_string( const char( &s )[N] )
		{
			initialize( s, static_cast< uint32 >( N - 1 ) );
		}
		// TODO : implement
		//		inline string_buffer_base( const string_twine& twine );

		~const_string()
		{
			if ( data() )
			{
				delete data();
			}
		}

		inline const_string( const_string&& other )
		{
			assign( other.data(), other.size() );
			other.assign( nullptr, 0 );
		}

		inline const_string& operator=( const_string&& other )
		{
			pointer   old_data = data();
			size_type old_size = size();
			assign( other.data(), other.size() );
			other.assign( old_data, old_size );
			return *this;
		}

		// blocked copy constructor
		const_string( const const_string & ) = delete;
		// blocked copy operator
		const_string& operator=( const const_string& ) = delete;

	private:

		void initialize( const char* p, size_type s )
		{
			char* new_data = new char[s + 1];
			if (p) nvmemcpy( new_data, p, s );
			new_data[s] = 0;
			assign( new_data, s );
		}
	};

}

#endif // NV_STL_STRING_CONST_STRING_HH
