// Copyright (C) 2012-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file gui_style.hh
 * @author Kornel Kisielewicz
 * @brief GUI style
 */

#ifndef NV_GUI_STYLE_HH
#define NV_GUI_STYLE_HH

#include <nv/gui/gui_element.hh>
#include <nv/lua/lua_state.hh>

namespace nv
{

	namespace gui
	{

		class style
		{
		public:
			style() : m_env( nullptr ) {}
			void set_environment( environment* env ) { m_env = env;  }
			void load_style( const string_view& filename );
			bool get( element* e, const string_view& centry, const string_view& cselector, string128& s );
			bool get( element* e, const string_view& centry, const string_view& cselector, vec4& vec );
			bool get( element* e, const string_view& centry, const string_view& cselector, int& i );
			bool get( element* e, const string_view& centry, const string_view& cselector, double& d );
			void load_flags( element* e );
			~style();
		protected:
			void add_flags( element* e );
			bool find_entry( const string_view& cselector, const string_view& centry, int type );
			bool resolve( shash64 cid, shash64 cclass, const string_view& cselector, const string_view& centry, int type );
		protected:
			environment* m_env;
			lua::state m_lua; //!< separate lua state for style calculation
		};

	} // namespace gui

} // namespace nv

#endif // NV_GUI_STYLE_HH
