// Copyright (C) 2016-2016 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
* @file default_resource_manager.hh
* @author Kornel Kisielewicz
* @brief engine default resource manager
*/

#ifndef NV_ENGINE_DEFAULT_RESOURCE_MANAGER_HH
#define NV_ENGINE_DEFAULT_RESOURCE_MANAGER_HH

#include <nv/common.hh>
#include <nv/interface/context.hh>
#include <nv/lua/lua_state.hh>
#include <nv/engine/resource_system.hh>
#include <nv/engine/program_manager.hh>
#include <nv/stl/array.hh>
#include <nv/gfx/skeleton_instance.hh>
#include <nv/engine/animation.hh>
#include <nv/engine/mesh_manager.hh>
#include <nv/engine/material_manager.hh>
#include <nv/engine/model_manager.hh>
#include <nv/engine/particle_manager.hh>
#include <nv/engine/ragdoll_manager.hh>

namespace nv
{

	class default_resource_manager : public resource_manager
	{
	public:
		explicit default_resource_manager( context* context, bool clear_material_paths = true );

		void add_path( const string_view& path );

		resource< gpu_mesh > get_gpu_mesh( resource< data_channel_set > mesh )
		{
			return m_gpu_meshes->load_resource( mesh );
		}
		resource< gpu_material > get_gpu_material( resource< material > m )
		{
			return m_gpu_materials->load_resource( m );
		}

		mesh_source get_source( resource< data_channel_set > mesh )
		{
			return m_mesh_datas->get_source( mesh );
		}

		nv::string_view resolve( nv::shash64 h )
		{
			return m_mesh_datas->resolve( h );
		}
		lua::state* get_lua() { return m_lua; }
		const type_database* get_type_db() { return m_lua->get_type_data()->get_type_database(); }

		virtual void initialize( lua::state* lua, physics_world* world );
		virtual void reload_data();
	protected:
		lua::state*            m_lua;
		image_manager*         m_images;
		material_manager*      m_materials;
		animator_bind_manager* m_binds;
		animator_manager*      m_animators;
		program_manager*       m_programs;
		gpu_mesh_manager*      m_gpu_meshes;
		gpu_material_manager*  m_gpu_materials;
		mesh_manager*          m_meshes;
		mesh_data_manager*     m_mesh_datas;
		model_manager*         m_models;
		particle_manager*      m_particles;
		ragdoll_manager*       m_ragdolls;
	};

}

#endif // NV_ENGINE_DEFAULT_RESOURCE_MANAGER_HH
