// Copyright (C) 2014-2017 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#ifndef NV_FORMATS_ASSIMP_LOADER_HH
#define NV_FORMATS_ASSIMP_LOADER_HH

#include <nv/common.hh>
#include <nv/stl/string_table.hh>
#include <nv/interface/mesh_loader.hh>
#include <nv/interface/mesh_data.hh>
#include <nv/interface/animated_mesh.hh>

namespace nv 
{

	struct assimp_data;

	class assimp_loader : public mesh_loader
	{
	public:
		explicit assimp_loader( string_table* strings, const string_view& a_ext, uint32 a_assimp_flags = 0 );
		virtual bool load( stream& source );
		virtual data_channel_set* release_mesh_data( uint32 index, data_node_info& info );
		virtual uint32 get_mesh_count() const { return m_mesh_count; }
		virtual ~assimp_loader();
		virtual uint32 get_nodes_data_count() const;
		virtual mesh_nodes_data* release_mesh_nodes_data( uint32 index = 0 );
		virtual data_node_list* release_data_node_list( uint32 = 0 );
		virtual bool is_animated( uint32 = 0 );
		void scene_report() const;
	private:
		bool is_node_animated();
		void build_skeleton( vector< data_node_info >& skeleton, const void* node, sint16 parent_id );
		data_node_list* release_merged_bones();
		void load_mesh_data( data_channel_set* data, uint32 index, data_node_info& info );
		sint16 load_node( uint32 anim_id, array_ref< data_channel_set* > nodes, array_ref< data_node_info > infos, const void* vnode, sint16 this_id, sint16 parent_id );
		void scan_nodes( const void* node ) const;
		uint32 count_nodes( const void* node ) const;
		data_channel_set* create_keys( const void* vnode, const transform& tr );


		assimp_data* m_data;

		vector< data_channel_set* > m_meshes;
		vector< data_node_info > m_mesh_info;
		hash_store< shash64, uint16 > m_bone_names;

		const_string m_ext;
		uint32 m_assimp_flags;
		uint32 m_mesh_count;
	};

}

#endif // NV_FORMATS_ASSIMP_LOADER_HH
